#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

/* Deklaracija funkcije centroid(). */
void centroid(float *x, float *y, float * z, int n, float *t);

int
main(void)
{
  int n;              /* Dimenzija prostora */
  float *x, *y, *z;   /* Pokazivaci na vektore koordinata tacaka x, y  i z*/
  float *t;           /* Pokazivac na vektor koordinata tezista t */
  int i;              /* Brojac u petljama */  

  /* Ucitavamo dimenziju */
  assert(scanf("%d", &n) == 1);
  
  /* Alociramo prostor */
  assert((x = malloc(sizeof(float)*n)) != NULL);
  assert((y = malloc(sizeof(float)*n)) != NULL);
  assert((z = malloc(sizeof(float)*n)) != NULL);
  assert((t = malloc(sizeof(float)*n)) != NULL);  

  /* Ucitavamo elemente vektora */
  for(i = 0;  i < n; i++)
    assert(scanf("%f", &x[i]) == 1);
  for(i = 0;  i < n; i++)
    assert(scanf("%f", &y[i]) == 1);
  for(i = 0;  i < n; i++)
    assert(scanf("%f", &z[i]) == 1);


  /* Pozivamo funkciju */
  centroid(x, y, z, n, t);

  /* Prikazujemo rezultat */
  for(i = 0;  i < n; i++)
    printf("%f ", t[i]);
  printf("\n");
  
  /* Oslobadjamo prostor */
  free(x);
  free(y);
  free(z);
  free(t);
  
  return 0;
}
