.intel_syntax noprefix

.data

three:	.float 3.0, 3.0, 3.0, 3.0
	
.text
.global centroid

############################################################################
##
## Funkcija:
##
## void centroid(float *x, float *y, float * z, int n, float *t);
##
## izracunava teziste trougla XYZ u n-dimenzionom prostoru.
## Argumenti funkcije:
##
## -- float * x -- [ebp+8] -- adresa vektora koordinata tacke X
## -- float * y -- [ebp+12] -- adresa vektora koordinata tacke Y
## -- float * z -- [ebp+16] -- adresa vektora koordinata tacke Z
## -- int n --     [ebp+20] -- dimenzija prostora
## -- float * t -- [ebp+24] -- adresa vektora koordinata rezultata (tezista)
##
############################################################################
centroid:
        ## Prolog funkcije.
        enter   0, 0
        push    ebx
        push    esi
        push    edi

        ## Proverava se da li procesor podrzava SSE instrukcije.
        mov     eax, 1
        cpuid
        test    edx, 0x2000000
        jz not_supported

        ## Cuva se sadrzaj SSE registara i registara koprocesora.
        mov     edx, esp
        and     esp, 0xfffffff0
        sub     esp, 512
        fxsave  [esp]

	## U ecx smestamo dimenziju n. U esi smestamo adresu vektora
	## koordinata tacke X, u edi Y a u ebx Z. Registar eax ce
	## sadrzati adresu rezultujuceg vektora.
	mov ecx, [ebp+20]
	mov esi, [ebp+8]
	mov edi, [ebp+12]
	mov ebx, [ebp+16]
	mov eax, [ebp+24]
	
	## Registar xmm0 ce sadrzati 3,3,3,3
	movups xmm0, three
next_four:
        ## Dokle god ima bar jos cetiri elemenata...
        cmp     ecx, 4
        jb next_one

	## ...ucitavamo sledeca cetiri elemenata iz sva tri vektora, sabiramo
	## ih i delimo zbir sa tri. Nakon toga smestamo koordinate u
	## rezultujuci niz.
        movups  xmm1, [esi]
        movups  xmm2, [edi]
	movups  xmm3, [ebx]
	addps xmm1, xmm2
	addps xmm1, xmm3
	divps xmm1, xmm0
	movups [eax], xmm1
        
        ## Prelazi se na narednu iteraciju.
        add     esi, 16
	add     edi, 16
	add     ebx, 16
	add     eax, 16
        sub     ecx, 4
        jmp next_four
        
next_one:
	## Dokle god ima jos elemenata...
        jecxz finish

	## ucitavamo po jedan element vektora X, Y, Z, sabiramo ih, delimo
	## sa 3 i smestamo u rezultujuci vektor.
	movss  xmm1, [esi]
        movss  xmm2, [edi]
	movss  xmm3, [ebx]
	addss xmm1, xmm2
	addss xmm1, xmm3
	divss xmm1, xmm0
	movss [eax], xmm1
        
        ## Prelazi se na narednu iteraciju.
        add     esi, 4
	add     edi, 4
	add     ebx, 4
	add     eax, 4
        dec     ecx
        jmp next_one
finish:
	
        ## Vraca se prethodni sadrzaj u registre koprocesora i SSE
        ## registre.
        fxrstor [esp]
        mov     esp, edx

done:
	## Epilog funkcije.
        pop     edi
        pop     esi
        pop     ebx
	leave
        ret

not_supported:
	## Ako SSE instrukcije nisu podrzane, prekidamo program exit(1)
        ## pozivom.
        mov eax, 1
        mov ebx, 1
        int 0x80
