.text
.align 2


.global ackermann

@ Funkcija:
@
@ int ackermann(int m, int n);
@
@ Izracunava Ackermann-ovu funkciju definisanu na sledeci nacin:
@
@ A(m,n) = n + 1             , za m = 0
@        = A(m-1,1)          , za m > 0, n = 0
@        = A(m-1,A(m,n-1))   , za m > 0, n > 0 
@  
@ Argumenti funkcije su:
@
@ int m -- r0
@ int n -- r1
@
ackermann:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Cuvamo na steku registre koje cemo da koristimo.
	stmfd sp!, {r4,r5} 

	@ Kopiramo vrednosti argumenata
	mov r4, r0 
	mov r5, r1

	@ Izlaz iz rekurzije (m == 0); u tom slucaju funkcija vraca n + 1.
	cmp r4, #0
	addeq r0, r5, #1
	beq done


	@ Slucaj kada je m > 0, n == 0
	cmp r5, #0
	subeq r0, r4, #1
	moveq r1, #1
	bleq ackermann
	beq done

	@ Slucaj kada je m > 0, n > 0
	@ Pozivamo A(m, n - 1)
	mov r0, r4
	sub r1, r5, #1
	bl ackermann
	
	@ Pozivamo A(m -1, A(m, n - 1)) (drugi operand je trenutno u r0)
	mov r1, r0
	sub r0, r4, #1
	bl ackermann
	 
done:
	@ Skidamo sa steka vrednosti registara koje smo koristili.
	ldmfd sp!, {r4,r5}

	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}

