#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include <math.h>

/* Deklaracija funkcije log_rational(). */
double log_rational(int m, double *p, int n, double *q, double x);

double test_log_rational(int m, double *p, int n, double *q, double x)
{
  int i;
  double P = 0 , Q = 0;
  
  for(i = m; i >= 0; i--)
    {
      P *= log(x);
      P += p[i];
    }

  for(i = n; i >= 0; i--)
    {
      Q *= log(x);
      Q += q[i];
    }

  return P/Q;

}


int main()
{
  int m;	/* Stepen polinoma p. */
  double *p;	/* Pokazivac na niz koeficienata polinoma p. */
  int n;	/* Stepen polinoma q. */
  double *q;	/* Pokazivac na niz koeficienata polinoma q. */
  double x;	/* Tacka u kojoj se racuna vrednost funkcije. */
  int i;	/* Brojac u petljama. */

  /* Ucitava se stepen polinoma p, alocira se memorija za niz 
     koeficienata i ucitavaju se koeficienti. */
  scanf("%d", &m);
  assert(m >= 0);
  p = malloc((m + 1) * sizeof(double));
  assert(p != NULL);
  for (i = 0; i <= m; i++)
    scanf("%lf", &p[i]);
  
  /* Ucitava se stepen polinoma p, alocira se memorija za niz 
     koeficienata i ucitavaju se koeficienti. */
  scanf("%d", &n);
  assert(n >= 0);
  q = malloc((n + 1) * sizeof(double));
  assert(q != NULL);
  for (i = 0; i <= n; i++)
    scanf("%lf", &q[i]);
  
  
  /* Ucitava se vrednost za koju se izracunava funkcija, a zatim
     se izracunava vrednost funkcije i stampa na standardni izlaz. */
  scanf("%lf", &x);
  printf("%.10f\n", log_rational(m, p, n, q, x));
  printf("%.10f\n", test_log_rational(m, p, n, q, x));
  
  /* Oslobadja se memorija  */
  free(p);
  free(q);
  
  return 0;
}

