.intel_syntax noprefix
        
.text
.global log_rational

##########################################################################
##
## Funkcija:
##
## double log_rational(int m, double *p, int n, double *q, double x);
##
## izracunava vrednost funkcije R(x) = P(x)/Q(x) gde je:
##
##	P(x) = p0 + p1*ln(x)+p2*ln(2x)+...+pm*ln(mx)
##	Q(x) = q0 + q1*ln(x)+q2*ln(2x)+...+qn*ln(nx)
##
## Argumenti funkcije su:
##
## -- int m -- [ebp+8] - stepen polinoma P
## -- double *p --  [ebp+12] - adresa niza koeficienata polinoma P
## -- int n -- [ebp+16] - stepen polinoma Q
## -- double *q --  [ebp+20] - adresa niza koeficienata polinoma Q
## -- double x  --  [ebp+24] - tacka u kojoj se racuna vrednost f-je.
##
## Funkcija vraca izracunatu vrednost. 
##
##########################################################################
log_rational:
        ## Prolog funkcije.
	enter   0, 0
        push    esi

	## Izracunava se vrednost t = ln(x)
	fldln2			# stek: ln(2)
        fld qword ptr [ebp+24]  # stek: ln(2), x
	fyl2x			# stek: ln(2)*log_2(x) = ln(x) = t
	
	## Izracunava se vrednost polinoma P(t) = p_0 + p_1*t + ... + p_m*t^m
	## Radi efikasnijeg racunanja, izraz se transformise u oblik:
        ##   P(t)=((...(0 * t + p_m)*t + p_{m-1})*t + p_{m-2})*t + ...)*t + p_0
        ## Registar esi ce sadrzati adresu tekuceg koeficienta polinoma
	## u brojiocu i inicijalizuje se na adresu koeficienta p_m.
	## Registar ecx se koristi kao brojac u petlji (imace pocetnu vrednost
	## m+1 jer je to broj iteracija).
        mov     ecx, [ebp+8]
        mov     esi, [ebp+12]
        mov     eax, ecx
	inc	ecx
        shl     eax, 3
        add     esi, eax

	## Inicijalna vrednost sume je 0.
	fldz			# Stek: t, 0 = S
next_p:
        fmul    st(0), st(1)    # Stek: t, S*t 
        fadd    qword ptr [esi] # Stek: t, S*t+p_i
        sub     esi, 8
				# Stek: t, S (nova vrednost sume)
        loop next_p

				# Stek: t, P(t)

	## Na slican nacin se izracunava vrednost polinoma Q(t) = q_0 + q_1*t
	## + ... + q_n*t^n. U registar ecx se ucitava n+1 (broj iteracija), a
	## u registar esi adresa koeficienta q_n.
        mov     ecx, [ebp+16]
        mov     esi, [ebp+20]
        mov     eax, ecx
        inc     ecx
        shl     eax, 3
        add     esi, eax

	## Inicijalna vrednost sume je 0.
	fldz			# Stek: t, P(t), 0 = S
next_q:
        fmul    st(0), st(2)    # Stek: t, P(t), S*t 
        fadd    qword ptr [esi] # Stek: t, P(t), S*t+q_i
        sub     esi, 8
				# Stek: t, P(t), S (nova vrednost sume)
        loop next_q

				# Stek: t, P(t), Q(t)
        
        
        fdivp                           # Stek: t, P(t)/Q(t)=R(t)
        fxch                            # Stek: R(t), t
        fcomp				# Stek: R(t)
        
	## Epilog funkcije.
        pop     esi
	leave
        ret
