.text
.align 2


.global fractions

@ Funkcija:
@
@ void fractions(int f1[], int f2[], int r[]);
@
@ izracunava zbir dva razlomka. Razlomci se zadaju kao nizovi 
@ celih brojeva duzine 2, pri cemu je prvi element tog niza 
@ brojilac, a drugi imenilac. Argumenti funkcije su:
@
@ r0 -- int * f1 -- adresa pocetka niza koji sadrzi brojilac i imenilac
@                   prvog razlomka
@ r1 -- int * f2 -- adresa pocetka niza koji sadrzi brojilac i imenilac
@                   drugog razlomka
@ r2 -- int * r  -- adresa pocetka niza koji sadrzi brojilac i imenilac
@                   rezultata
@
fractions:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	stmfd sp!, {r4-r8}

	@ U registar r8 smestamo adresu rezultujuceg niza
	mov r8, r2

	@ U registru r4 racunamo proizvod imenioca f1[1] * f2[1]
	ldr r3, [r0, #4]
	ldr r5, [r1, #4]
	mul r4, r3, r5
	
	@ U registru r5 racunamo proizvod f1[0]*f2[1]
	ldr r3, [r0]
	ldr r6, [r1,#4]
	mul r5, r3, r6

	@ U registru r6 racunamo proizvod f2[0]*f1[1]
	ldr r3, [r0, #4]
	ldr r7, [r1]
	mul r6, r7, r3

	@ Racunamo zbir f1[0]*f2[1] + f2[0]*f1[1] u registru r5
	add r5, r5, r6

	@ Sada se u r4 nalazi imenilac a u r5 brojilac. Potrebno je jos 
        @ skratiti razlomak. U tu svrhu najpre pronalazimo NZD 
	@ Euklidovim algoritmom.

	mov r6, r4
	mov r7, r5
next:
	cmp r7, #0
	beq last

	mov r0, r6
	mov r1, r7
	bl __modsi3

	mov r6, r7
	mov r7, r0

	b next
last:

	@ Sada se NZD(r4, r5) nalazi u r6. Potrebno je jos podeliti oba 
	@ sa r6.
	mov r0, r4
	mov r1, r6
	bl __divsi3
	mov r4, r0
	mov r0, r5
	mov r1, r6
	bl __divsi3
	mov r5, r0

	@ Na kraju cuvamo vrednosti brojioca i imenioca na za to 
	@ predvidjene lokacije.
	str r5, [r8]
	str r4, [r8, #4]

done:

	ldmfd sp!, {r4-r8}

	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}
