.intel_syntax noprefix

.data
sixteen: .int 16
	
.text
.global digits

##########################################################################
##
## Funkcija:
##
## void digits(unsigned n, unsigned *c1, unsigned *c2);
##
## odredjuje dve najvece cifre heksadekadnog zapisa pozitivnog broja n.	
## Argumenti funkcije su:
##
## -- int n  -- [ebp+8]  -- dati broj
## -- int *c1  -- [ebp+12] -- adresa na koju treba upisati najvecu cifru
## -- int *c2  -- [ebp+16] -- adresa na koju treba upisati drugu najvecu
##                            cifru
##
###########################################################################
digits:
        ## Prolog funkcije.
        enter   0, 0
        push    esi
        push    edi

	## Ucitavamo broj n u eax.
	mov eax, [ebp + 8]

	## Registar esi ce cuvati najvecu cifru, a registar edi
	## drugu najvecu cifru broja n.
	xor esi, esi
	xor edi, edi

	## Ako je n == 0, preskacemo petlju.
	cmp eax, 0
	je last

	## Petlja:
next:
	## Delimo broj n sa 16. Nakon deljenja se sledeca izdvojena cifra
	## nalazi u registru edx.
	xor edx, edx
	div dword ptr sixteen

	## Proveravamo da li je tekuca cifra veca od najvece cifre
check_first:
	cmp edx, esi
	ja found_first

	## Proveravamo da li je tekuca cifra veca od druge najvece cifre
check_second:
	cmp edx, edi
	ja found_second

	jmp continue
	
found_first:
	## Ako je pronadjena cifra veca od najvece, tada azuriramo obe najvece
	## cifre: prethodna najveca postaje druga najveca, a nova cifra
	## postaje najveca cifra.
	mov edi, esi
	mov esi, edx
	jmp continue

found_second:
	## Ako je pronadjena cifra vece od druge najvece, tada azuriramo samo
	## drugu najvecu.
	mov edi, edx
	jmp continue
	
continue:
	## Ako je nakon deljenja kolicnik 0, znaci da nema vise cifara. U
	## suprotnom, idemo na sledecu iteraciju.
	cmp eax,0
	ja next
last:	

	## Upisujemo najmanju cifru u za to predvidjenu lokaciju.
	mov eax, [ebp+12]
	mov [eax], esi

	## Upisujemo najvecu cifru u za to predvidjenu lokaciju.
	mov eax, [ebp+16]
	mov [eax], edi

done:	
	## Epilog funkcije
	pop edi
	pop esi
	leave
	ret
	