#include <stdio.h>
#include <math.h>

/* NAPOMENA:

   Funkcije u C-u imaju ogranicenje da mogu vratiti najvise jednu vrednost
   pozivajucoj funkciji (naredbom return). Ovo ogranicenje se takodje moze
   prevazici koriscenjem pokazivaca -- deklarisemo funkciju tako da ima
   parametre pokazivackih tipova, a zatim u lokacije na koje ti pokazivaci
   pokazuju upisemo rezultate izracunavanja (jasno je da ih sada moze biti
   proizvoljno mnogo). Sve sto treba uraditi prilikom poziva je da se kao
   odgovarajuci argumenti predaju ADRESE promenljivih u koje zelimo da 
   upisemo rezultate izracunavanja. 
*/

#define EPS 0.000001

/* Funkcija izracunava realna resenja kvadratne jednacine a*x^2 + b*x + c = 0.
   Funkcija vraca broj realnih resenja, a sama resenja vraca preko pokazivaca
   x1 i x2 */
int kvadratna_jednacina(double a, double b, double c, 
			double *x1, double *x2) 
{
  double D;

  /* Racunamo diskriminantu */
  D = b * b - 4 * a * c;

  if(D < 0)
    return 0; /* Ako nema realnih resenja, vracamo 0 */
  else if(fabs(D) < EPS)
    {
      /* Ako imamo samo jedno realno resenje -- tada ga upisujemo na lokaciju
	 na koju pokazuje (npr.) pokazivac x1, i vracamo vrednost 1 */
      *x1 = -b / (2 * a); 
      return 1;
    }
  else 
    {
      /* Ako imamo dva realna resenja, tada prvo upisujemo na lokaciju na koju
	 pokazuje x1, a drugo na lokaciju na koje pokazuje x2, i vracamo 2 */
      *x1 = (-b + sqrt(D)) / (2 * a);
      *x2 = (-b - sqrt(D)) / (2 * a);
      return 2;
    }
}


int main()
{
  double x1, x2;
  double a, b, c;
  int r;

  /* Ucitavamo koeficiente a, b, c (primetimo specifikator %lf -- koristi se
     u scanf()-u za ucitavanje podataka tipa double) */
  scanf("%lf %lf %lf", &a, &b, &c);

  /* Poziv funkcije: prenosimo VREDNOSTI promenljivih a,b,c, kao i ADRESE 
     promenljivih x1 i x2 (koje odgovaraju pokazivackim parametrima x1 i x2
     u funkciji). */
  r = kvadratna_jednacina(a, b, c, &x1, &x2); 
  
  /* Diskutujemo povratnu vrednost funkcije */
  switch(r)
    {
    case 0:
      printf("Nema resenja!\n");
      break;
    case 1:
      printf("Postoji jedno realno resenje: %f\n", x1);
      break;
    case 2:
      printf("Postoje dva realna resenja: %f i %f\n", x1, x2);
      break;
    }

  return 0;
}
