#include <stdio.h>

/* Funkcija izracunava NZD(n, k), koristeci Euklidov algoritam */
int nzd(int n, int k)
{
  int r;

  /* Euklodov algoritam se zasniva na sledecoj cinjenici, poznatoj iz
     elementarne algebre: ako je n = q*k + r, tada iz d|k i d|r sledi da
     d|n, kao i iz d|n i d|k sledi da d|r, pa se otuda skupovi zajednickih
     delilaca za parove (n,k), i za (k,r) poklapaju. Otuda je 
     NZD(n,k)=NZD(k,r), i n > k i k > r, pa se problem svodi na nalazenje
     nzd-a manjih brojeva. Dakle, proglasimo k za novo n, a r za novo k i 
     ponavljamo postupak. Kada k postane 0 (to ce se desiti nakon konacnog
     broja iteracija), tada je NZD(n,k)=NZD(n,0)=n, sto je i NZD polaznog
     para brojeva. */
     
  while(k)
    {
      r = n % k;

      n = k;
      k = r;
    }

  return n;
}

/* Funkcija racuna tzv. Ojlerovu funkciju -- broj prirodnih brojeva iz
   skupa 1, 2, ... n - 1, koji su uzajamno prosti sa n. */ 
int euler(int n)
{
  int k;
  int S = 0;

  for(k = 1; k < n; k++)
    if(nzd(n, k) == 1) /* Uzajamno su prosti ako im je NZD 1 */
      S++;

  return S;
}

int main()
{
  int n;
  
  scanf("%d", &n);

  printf("Vrednost Ojlerove funkcije je: %d\n", euler(n));


  return 0;
}
