#include <stdio.h>

/* NAPOMENA: 

   Definicija funkcije ima sledecu sintaksu:

   povratni_tip ime_funkcije(lista_parametara)
   {
      deklaracije_lokalnih_promenljivih
      naredbe
   }

   Pri cemu je lista_parametara ili prazna, ili oblika:

   tip ime_parametra

   ili oblika (ako ima vise od jednog parametra):

   tip1 ime1, tip2 ime2, ..., tipn imen

   Deklaracije lokalnih promenljivih izgledaju isto kao i u main() funkciji.
   Treba naglasiti da svaka funkcija ima svoje lokalne promenljive koje su
   vidljive samo njoj, i nemaju nikakve veze sa lokalnim promenljivama 
   drugih funkcija, pa ni funkcije main (pa cak i ako se isto zovu). Lokalne
   promenljive imaju zivotni vek vezan za trajanje izvrsenja poziva funkcije:
   lokalne promenljive se kreiraju u memoriji kada se funkcija pokrene, a 
   unistavaju se kada se funkcija zavrsi. Pri svakom pozivu funkcije, ovo 
   kreiranje i unistavanje se iznova desava.

   Parametri funkcije su takodje lokalne promenljive, i za njih vazi sve sto
   je receno za lokalne promenljive. Jedino sto je za njih karakteristicno je
   da se prilikom poziva INICIJALIZUJU vrednostima argumenata koji se predaju
   u pozivu funkcije.

   Izvrsavanje funkcije mora da se zavrsi naredbom:
   
   return izraz;

   gde tip izraza odgovara tipu koji je deklarisan kao povratni tip funkcije
   (ili je tip izraza takav da se moze implicitno konvertovati u povratni
   tip funkcije). Vrednost izraza koju funkcija vrati je upravo vrednost
   izraza poziva, na mestu pozivanja u pozivajucoj funkciji. Ukoliko 
   postoji vise mogucih nacina izvrsenja funkcije (grananje u algoritmu, i
   sl.), tada svaka izlazna grana mora imati odgovarajuci return.

   Izuzetak od gornjeg pravila su funkcije koje vracaju tip void -- prazan
   tip. S obzirom da prazan tip nema vrednosti, ovakve funkcije ne vracaju
   nista, pa samim tim ne moraju da imaju return. Njihovo se izvrsavanje
   zavrsava izvrsenjem poslednje naredbe u telu funkcije. Naravno, i u ovim
   funkcijama moze da postoji naredba:

   return;

   kojom se prosto bezuslovno prekida izvrsenje funkcije, ne vracajuci nista.
   
   Poziv funkcije izgleda ovako:

   ime_funkcije(arg1, arg2, ..., argn)

   i predstavlja IZRAZ, ciji je tip upravo povratni tip funkcije, a vrednost
   izraza poziva je ono sto taj poziv funkcije vrati naredbom
   return. Argumenti arg1,...,argn su bilo koji IZRAZI. Njihove vrednosti se
   najpre izracunaju, a zatim se kopiraju u odgovarajuce lokalne parametre
   funkcije, zadajuci im tako inicijalne vrednosti. Ovakav nacin prenosenja
   argumenata se zove PRENOSENJE PO VREDNOSTI, jer se samo vrednosti izraza
   KOPIRAJU funkciji. Ukoliko tipovi argumenata ne odgovaraju tipovima 
   lokalnih parametara, tada se vrsi implicitna konverzija u tip odgovarajuceg
   parametra (ako je to moguce).

   Ukoliko funkcija ima praznu listu parametara, npr.
   
   int getchar() { ... }

   tada se ona poziva sa: 
   
   getchar()

   tj. prazne zagrade je obavezno navesti i prilikom poziva (dakle, ne moze
   se samo reci getchar). 

   Ukoliko funkcija ima povratni tip void (tj. ne vraca nista), tada njen
   poziv nema vrednost, pa se ne moze koristiti kao deo nekog sireg izraza.
   Jedini nacin da se pozove void funkcija je oblika:

   ime_funkcije(argumenti);

   tj. vrednost izraza poziva mora biti ignorisana.

   Jedna funkcija moze pozivati druge funkcije, a taj proces se moze nastaviti
   do (teorijski) proizvoljne dubine. 

   Funkcija main() je funkcija kao i svaka druga, s tom razlikom sto nju 
   operativni sistem automatski poziva prilikom pokretanja programa, a njenim
   zavrsetkom se i program smatra zavrsenim. Ova funkcija po konvenciji na 
   UNIX sistemima vraca int, a ta celobrojna vrednost se vraca operativnom
   sistemu. Dogovor je da to bude vrednost 0 ako je program protekao u redu,
   a razlicito od 0 ako je nastupila neka greska. Na UNIX sistemima se ta
   vrednost najcesce moze ocitati komandom:

   echo $?

   neposredno nakon zavrsetka izvrsenja komande (programa). 
 */


/* Funkcija proverava da li je dati broj prost. Vraca 1 ako jeste, 
   a 0 ako nije */
int prost(int n)
{
  int k;

  for(k = 2; k*k <= n; k++)
    {
      if(n % k == 0)
	return 0;
    }
  
  return 1;
}

/* Funkcija pronalazi i prikazuje prvih m prostih brojeva. Ne vraca nista */
void prikazi_proste(int m)
{
  int n;

  if(m > 0)
    {
      printf("2 ");
      m--;
    }

  for(n = 3; m > 0; n += 2)
    {
      if(prost(n))
	{
	  printf("%d ", n);
	  m--;
	}
    }
}


/* Program prikazuje prvih m prostih brojeva */
int main()
{
  int n, m;

  /* Ucitavamo ceo broj m */
  scanf("%d", &m);

  /* Pozivamo funkciju koja ispisuje prvih m prostih brojeva */
  prikazi_proste(m);

  /* Prikazujemo vrednost promenljive m -- vidimo da nije promenjena!! */
  printf("\nPromenljiva m nakon poziva funkcije: %d\n", m);

  return 0;
}
