#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define MAX_STR 1000

/* FUNKCIJE SA VEZBI KOJE CEMO KORISTITI */

unsigned karakter_u_cifru(char c)
{
  return isdigit(c) ? c - '0' : c - 'A' + 10;
}

char cifra_u_karakter(unsigned d)
{
  return d < 10 ? d + '0' : d - 10 + 'A';
}

void obrni_string(char * s)
{
  int n = strlen(s);
  int i, j;
  for(i = 0, j = n - 1; i < j; i++, j--)
    {
      unsigned t = s[i];
      s[i] = s[j];
      s[j] = t;
    }
}

void konvertuj_iz_binarnog(unsigned x, unsigned b, char * r)
{
  unsigned i = 0;
  while(x != 0)
    {
      r[i++] = cifra_u_karakter(x % b);
      x = x / b;
    }
  r[i] = '\0';
  obrni_string(r);
}


void sabiranje(char * x, char * y, unsigned b, char * r, unsigned * c)
{
  unsigned xc, yc, rc, pc = 0;
  int i;
  int n = strlen(x);
  for(i = n - 1; i >= 0 ; i--)
    {
      xc = karakter_u_cifru(x[i]);
      yc = karakter_u_cifru(y[i]);
      rc = (xc + yc + pc) % b;
      pc = (xc + yc + pc) / b;
      r[i] = cifra_u_karakter(rc);
    }
  r[n] = '\0';
  *c = pc;
}

void oduzimanje(char * x, char * y, unsigned b, char * r, unsigned * c)
{
  unsigned xc, yc, rc, pc = 0;
  int i;
  int n = strlen(x);
  for(i = n - 1; i >= 0 ; i--)
    {
      xc = karakter_u_cifru(x[i]);
      yc = karakter_u_cifru(y[i]);
      unsigned p = xc < (yc + pc);
      rc = !p ? xc - (yc + pc) : xc + b - (yc + pc);
      pc = p;
      r[i] = cifra_u_karakter(rc);
    }
  r[n] = '\0';
  *c = pc;
}

void dodaj_k_pratecih_nula(char * x, unsigned k)
{
  int n = strlen(x);
  while(k)
    {
      x[n++] = '0';
      k--;
    }
  x[n] = '\0';   
}

void dodaj_k_vodecih_nula(char * x, unsigned k)
{
  int n = strlen(x);
  x[n + k] = '\0';
  while(n)
    {
      n--;
      x[n + k] = x[n]; 
    }
  while(k)
    {
      k--;
      x[k] = '0';
    }
}

void obrisi_vodece_nule(char * x)
{
  int i = 0, j = 0;
  while(x[i] == '0') i++; /* Preskacemo sve vodece nule */

  while(x[i] != '\0') /* Prepisujemo ostale cifre na pocetak */
    x[j++] = x[i++];

  if(j != 0)
    x[j] = '\0';
  else /* Specijalni slucaj: kada su sve cifre nule, treba ostaviti jednu */
    {
      x[0] = '0';
      x[1] = '\0';
    }
}

void izjednaci_sirine_zapisa(char * x, char * y)
{
  int nx = strlen(x), ny = strlen(y);
  if(nx < ny)
    dodaj_k_vodecih_nula(x, ny - nx);
  else if(nx > ny)
    dodaj_k_vodecih_nula(y, nx - ny);
}

void prosireno_sabiranje(char * x, char * y, unsigned b, char * r)
{
  unsigned c;
  sabiranje(x, y, b, r, &c);
  if(c != 0) /* Ako imamo prekoracenje, dopisujemo jedinicu na pocetak */
    {
      dodaj_k_vodecih_nula(r, 1);
      r[0] = '1';
    }
}

void deljenje(char * x, char * y, unsigned b, char * q, char * r)
{
  char yp[MAX_STR];
  int i;
  unsigned c = 0;
  unsigned nr;
  unsigned d;
  r[0] = '\0';
  q[0] = '\0';
  strcpy(yp, y);
  
  for(i = 0; x[i] != '\0'; i++)
    {
      nr = strlen(r);      
      r[nr] = x[i];
      r[nr + 1] = '\0'; /* "spustamo" u r sledecu cifru iz x */
      izjednaci_sirine_zapisa(r, yp); /* ...kako bismo mogli da ih oduzimamo */
      c = 0;
      d = 0;
      while(c == 0) /* Brojimo koliko puta mozemo da oduzmemo yp od r */
	{
	  oduzimanje(r, yp, b, r, &c);
	  d++;
	}
      
      /* Ponistavamo poslednje (neuspesno) oduzimanje */
      d--;
      sabiranje(r, yp, b, r, &c);

      /* Upisujemo cifru d na kraj kolicnika q */
      dodaj_k_pratecih_nula(q, 1);	  
      q[strlen(q) - 1] = cifra_u_karakter(d);
    }

  obrisi_vodece_nule(q);
  obrisi_vodece_nule(r);
}


/* FUNKCIJA KOJA SE TRAZILA U ZADATKU */

void nzd(char * x, char * y, unsigned b, char * d)
{
  char xp[MAX_STR], yp[MAX_STR];
  strcpy(xp, x); /* Kopije x i y podatka */
  strcpy(yp, y);

  /* Euklidov algoritam NZD(x, y) = NZD(y, x % y) */
  while(strcmp(yp, "0") != 0)
    {
      char q[MAX_STR], r[MAX_STR];
      deljenje(xp, yp, b, q, r);
      strcpy(xp, yp);
      strcpy(yp, r);
    }
  strcpy(d, xp);
}


int main()
{
  unsigned b;
  char x[MAX_STR], y[MAX_STR], d[MAX_STR];
  
  scanf("%u", &b);
  scanf("%s %s", x, y);
  nzd(x, y, b, d);
  printf("%s\n", d);
  
  return 0;
}
