#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define MAX_STR 1000

/* FUNKCIJE SA VEZBI KOJE CEMO KORISTITI */

unsigned karakter_u_cifru(char c)
{
  return isdigit(c) ? c - '0' : c - 'A' + 10;
}

char cifra_u_karakter(unsigned d)
{
  return d < 10 ? d + '0' : d - 10 + 'A';
}

void obrni_string(char * s)
{
  int n = strlen(s);
  int i, j;
  for(i = 0, j = n - 1; i < j; i++, j--)
    {
      unsigned t = s[i];
      s[i] = s[j];
      s[j] = t;
    }
}

void konvertuj_iz_binarnog(unsigned x, unsigned b, char * r)
{
  unsigned i = 0;
  while(x != 0)
    {
      r[i++] = cifra_u_karakter(x % b);
      x = x / b;
    }
  r[i] = '\0';
  obrni_string(r);
}


void sabiranje(char * x, char * y, unsigned b, char * r, unsigned * c)
{
  unsigned xc, yc, rc, pc = 0;
  int i;
  int n = strlen(x);
  for(i = n - 1; i >= 0 ; i--)
    {
      xc = karakter_u_cifru(x[i]);
      yc = karakter_u_cifru(y[i]);
      rc = (xc + yc + pc) % b;
      pc = (xc + yc + pc) / b;
      r[i] = cifra_u_karakter(rc);
    }
  r[n] = '\0';
  *c = pc;
}

void oduzimanje(char * x, char * y, unsigned b, char * r, unsigned * c)
{
  unsigned xc, yc, rc, pc = 0;
  int i;
  int n = strlen(x);
  for(i = n - 1; i >= 0 ; i--)
    {
      xc = karakter_u_cifru(x[i]);
      yc = karakter_u_cifru(y[i]);
      unsigned p = xc < (yc + pc);
      rc = !p ? xc - (yc + pc) : xc + b - (yc + pc);
      pc = p;
      r[i] = cifra_u_karakter(rc);
    }
  r[n] = '\0';
  *c = pc;
}

void dodaj_k_pratecih_nula(char * x, unsigned k)
{
  int n = strlen(x);
  while(k)
    {
      x[n++] = '0';
      k--;
    }
  x[n] = '\0';   
}

void dodaj_k_vodecih_nula(char * x, unsigned k)
{
  int n = strlen(x);
  x[n + k] = '\0';
  while(n)
    {
      n--;
      x[n + k] = x[n]; 
    }
  while(k)
    {
      k--;
      x[k] = '0';
    }
}

void obrisi_vodece_nule(char * x)
{
  int i = 0, j = 0;
  while(x[i] == '0') i++; /* Preskacemo sve vodece nule */

  while(x[i] != '\0') /* Prepisujemo ostale cifre na pocetak */
    x[j++] = x[i++];

  if(j != 0)
    x[j] = '\0';
  else /* Specijalni slucaj: kada su sve cifre nule, treba ostaviti jednu */
    {
      x[0] = '0';
      x[1] = '\0';
    }
}

void izjednaci_sirine_zapisa(char * x, char * y)
{
  int nx = strlen(x), ny = strlen(y);
  if(nx < ny)
    dodaj_k_vodecih_nula(x, ny - nx);
  else if(nx > ny)
    dodaj_k_vodecih_nula(y, nx - ny);
}

void prosireno_sabiranje(char * x, char * y, unsigned b, char * r)
{
  unsigned c;
  sabiranje(x, y, b, r, &c);
  if(c != 0) /* Ako imamo prekoracenje, dopisujemo jedinicu na pocetak */
    {
      dodaj_k_vodecih_nula(r, 1);
      r[0] = '1';
    }
}

void deljenje(char * x, char * y, unsigned b, char * q, char * r)
{
  char yp[MAX_STR];
  int i;
  unsigned c = 0;
  unsigned nr;
  unsigned d;
  r[0] = '\0';
  q[0] = '\0';
  strcpy(yp, y);
  
  for(i = 0; x[i] != '\0'; i++)
    {
      nr = strlen(r);      
      r[nr] = x[i];
      r[nr + 1] = '\0'; /* "spustamo" u r sledecu cifru iz x */
      izjednaci_sirine_zapisa(r, yp); /* ...kako bismo mogli da ih oduzimamo */
      c = 0;
      d = 0;
      while(c == 0) /* Brojimo koliko puta mozemo da oduzmemo yp od r */
	{
	  oduzimanje(r, yp, b, r, &c);
	  d++;
	}
      
      /* Ponistavamo poslednje (neuspesno) oduzimanje */
      d--;
      sabiranje(r, yp, b, r, &c);

      /* Upisujemo cifru d na kraj kolicnika q */
      dodaj_k_pratecih_nula(q, 1);	  
      q[strlen(q) - 1] = cifra_u_karakter(d);
    }

  obrisi_vodece_nule(q);
  obrisi_vodece_nule(r);
}


/* FUNKCIJA KOJA SE TRAZILA U ZADATKU */

int prost_broj(char * x, unsigned b)
{
  /* Algoritam cemo sprovesti grubom silom: za svaki broj d iz
     intervala [2, x) cemo ispitivati da li je x % d == 0. */
  
  char d[MAX_STR];   // Tekuci delilac
  char xp[MAX_STR];  // Kopija podatka x

  char jedan[MAX_STR]; // Jedinica: dodavanjem jedinice implementiramo ++ operaciju  
  jedan[0] = '1';
  jedan[1] = '\0';

  // Delilac inicijalizujemo na 2 (zapisan u osnovi b)
  konvertuj_iz_binarnog(2, b, d);

  // Kopiramo x u xp
  strcpy(xp, x);

  /* Uslov petlje: dokle god je d < xp. Ovo uporedjivanje vrsimo tako sto 
     zapise poredimo leksikografski. LLako se uocava da ukoliko su zapisi
     jednakih duzina, tada ce d biti manje od xp ako i samo ako je d kao
     string leksikografski manji od xp. Zbog toga moramo da im najpre
     izjednacimo sirine zapisa */
  izjednaci_sirine_zapisa(xp, d);
  while(strcmp(d, xp) < 0)
    {
      char q[MAX_STR], r[MAX_STR];

      /* Delimo xp sa d. Zanima nas ostatak r */
      deljenje(xp, d, b, q, r);
     
      /* Ako je r == 0, tada je broj slozen. S obzirom da funkcija deljenja
	 brise nepotrebne vodece nule, znamo da ce nula biti zapisana kao
	 "0", pa mozemo strcmp() funkcijom da ispitamo da li je r == 0 */
      if(strcmp(r, "0") == 0)
	return 0;

      /* Prelazimo na sledeci delilac. Najpre izjednacavamo sirine zapisa
	 d i jedan, kako bismo mogli da ih saberemo. Ovim se d uvecava 
	 za jedan, a onda se ponovo izjednace sirine zapisa xp i d, kako bi
	 u uslovu petlje mogli da se uporedjuju */
      izjednaci_sirine_zapisa(d, jedan);
      prosireno_sabiranje(d, jedan, b, d);
      izjednaci_sirine_zapisa(xp, d);
    }
  return 1;
}


int main()
{
  unsigned b;
  char x[MAX_STR];

  scanf("%u", &b);
  scanf("%s", x);
  if(prost_broj(x, b))
    printf("prost\n");
  else
    printf("nije prost\n");
  
  return 0;
}
