.intel_syntax noprefix


.text
.global remove_elements

###########################################################################
##
## Funkcija uklanja iz niza sve elemente koji ne dele sumu prethodnih
## elemenata u pocetnom nizu. Funkcija vraca broj elemenata rezultujuceg
## niza.
##	
## int remove_elements(int * a, int n);
##
## -- int * a -- [ebp+8] -- pokazivac na pocetni element niza.
## -- int n -- [ebp+12] -- duzina niza
##
###########################################################################
remove_elements:
	## Prolog funkcije
	enter 0,0
	push esi
	push edi
	push ebx

	## Registar ebx ce cuvati sumu prethodnih elemenata.
	mov ebx, 0

	## Registar ecx ce biti brojac u petlji. Inicijalno se postavlja
	## na broj elemenata u nizu.
	mov ecx, [ebp + 12]

	## Registar esi ce biti pokazivac na tekuci element koji se ispituje,
	## dok ce registar edi biti pokazivac na poziciju na koju treba
	## smestiti sledeci element rezultujuceg niza.
	mov esi, [ebp + 8]
	mov edi, esi

	## Postavljamo pravac kretanja kroz niz u smeru sa leva na desno.
	cld
	
next_number:
	## Ucitavamo sledeci element niza u eax.
	lodsd

	## Cuvamo sumu prethodnih elemenata na stek, a zatim razmenjujemo
	## registre eax i ebx, tako da je sada u eax-u suma, a u ebx-u
	## ucitani element.
	push ebx
	xchg eax, ebx

	## Delimo sumu ucitanim elementom. Ucitani element ostaje u ebx
	## registru, nakon cega ga vracamo u eax registar.
	cdq
	idiv ebx
	mov eax, ebx
	
	## Ispitujemo deljivost.
	cmp edx, 0
	jne continue

	## Ako je deljivo, tada upisujemo tekuci element u rezultujuci niz.
	stosd

continue:
	## Vracamo sumu u ebx i uvecavamo je za vrednost tekuceg elementa.
	pop ebx
	add ebx, eax

	## Prelazimo na sledecu iteraciju.
	loop next_number

	## Izracunavamo broj elemenata u rezultujucem nizu tako sto oduzmemo
	## adresu pocetka niza od adrese kraja rezultujuceg niza i to podelimo
	## sa 4.
	mov esi, [ebp + 8]
	sub edi, esi
	sar edi, 2

	## Vracamo izracunatu duzinu.
	mov eax, edi
done:	
	## Epilog funkcije
	pop ebx
	pop edi
	pop esi
	leave
	ret
	
