#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

/* Deskriptivna imena za indekse koordinata tacaka. */
#define X 0
#define Y 1
#define Z 2

/* Deklaracija asemblerske funkcije. */
void closest(int n, float * P, float * A, float * B, float * R);

int main()
{
  int  n;	/* Broj tacaka. */
  float * P;	/* Pokazivac na niz sa koordinatama tacaka. */
  float A[3];	/* Koordinate prve tacke. */
  float B[3];	/* Koordinate druge tacke. */
  float R;      /* Rastojanje izmedju tacaka */
  int   i;	/* Brojac u petljama. */

  
  /* Ucitava se broj tacaka (bar 2) */
  assert(scanf("%d", &n) == 1);
  assert(n > 1);
  
  /* Alociramo prostor za koordinate tacaka */
  assert((P = malloc(3 * n * sizeof(float))) != NULL);
	
  
  /* Ucitavaju se koordinate tacaka. */
  for (i = 0; i < n; ++i) 
    {
      assert(scanf("%f%f%f", 
		   &P[3 * i + X], 
		   &P[3 * i + Y], 
		   &P[3 * i + Z]) == 3); 
    }

  
  /* Poziva se funkcija i prikazuje se njen rezultat */
  closest(n, P, A, B, &R);
  printf("%g %g %g\n", A[X], A[Y], A[Z]);
  printf("%g %g %g\n", B[X], B[Y], B[Z]);
  printf ("%g\n", R); 


  /* Oslobadja se memorija. */
  free(P);
  
  return 0;
}
