.intel_syntax noprefix

.text
.global closest

#########################################################################
##
## Funkcija:
##
## void closest(int n, float * P, float * A, float * B, float * R);
##
## odredjuje dve tacke u nizu tacaka sa najmanjim medjusobnim rastojanjem. 
## Parametri funkcije su:
##
## -- int n -- [ebp+8] -- broj tacaka u nizu.
## -- float * P -- [ebp+12] -- adresa pocetka niza koordinata.
## -- float * A -- [ebp+16] -- adresa pocetka niza koordinata tacke A.
## -- float * B -- [ebp+20] -- adresa pocetka niza koordinata tacke B.
## -- float * R -- [ebp+24] -- adresa na koju se upisuje rastojanje.
#########################################################################
closest:
        ## Prolog funkcije.
	enter   16, 0
        push    ebx
        push    esi
        push    edi

        ## Proverava se da li procesor podrzava SSE instrukcije.
        mov     eax, 1
        cpuid
        test    edx, 0x2000000
        jz done

        ## Cuva se sadrzaj SSE registara i registara koprocesora.
        mov     edx, esp
        and     esp, 0xfffffff0
        sub     esp, 512
        fxsave  [esp]

	## Postavljamo smer kretanja kroz niz.
	cld
	
        ## Registar esi ce sadrzati adresu na kojoj su smestene koordinate
	## tekuce tacke.
        mov     esi, [ebp+12]

	## Preko pomocnog niza, u registar xmm1 se upisuju koordinate
	## prve tacke.
        mov     ecx, 3
        lea     edi, [ebp-16]
        rep movsd
        movups  xmm1, [ebp-16]
       
	## Preko pomocnog niza, u registar xmm2 se upisuju koordinate
	## druge tacke.
        mov     ecx, 3
        lea     edi, [ebp-16]
        rep movsd
        movups  xmm2, [ebp-16]

	## Izracunava se euklidsko rastojanje izmedju prve dve tacke i
	## smesta se u najnizi podatak registra xmm3.
	movaps xmm3, xmm1
	subps xmm3, xmm2
	mulps xmm3, xmm3
	movhlps xmm4, xmm3
	addss xmm3, xmm4
	movaps xmm4, xmm3
	shufps xmm4, xmm4, 0b01010101
	addss xmm3, xmm4
	sqrtss xmm3, xmm3
	
	## Na dalje ce dve tacke sa najmanjim rastojanjem biti cuvane u xmm1 i
	## xmm2, a njihovo rastojanje u najnizem podatku registra xmm3.

	## Vracamo u esi adresu pocetne tacke, a u ecx upisujemo broj tacaka.
	mov     esi, [ebp+12]
	mov 	ecx, [ebp+8]
	
outer_loop:        
        ## Preko pomocnog niza, u registar xmm4 se upisuju koordinate
	## tekuce tacke u spoljasnjoj petlji.
        mov     eax, ecx
        mov     ecx, 3
        lea     edi, [ebp-16]
        rep movsd
        movups  xmm4, [ebp-16]
        mov     ecx, eax

	## Stavljamo na stek brojac i pokazivac na tekucu tacku, jer cemo
	## ih koristiti i u unutrasnjoj petlji. 
	push esi
	push ecx

	## Registar ecx se postavlja da sadrzi broj preostalih tacaka iza
	## tekuce (toliko ce biti iteracija u unutrasnjoj petlji).
	dec ecx
	jecxz continue_outer
	
inner_loop:

	## Preko pomocnog niza, u registar xmm5 se upisuju koordinate
	## tekuce tacke u unutrasnjoj petlji.
        mov     eax, ecx
        mov     ecx, 3
        lea     edi, [ebp-16]
        rep movsd
        movups  xmm5, [ebp-16]
        mov     ecx, eax

	## Izracunava se euklidsko rastojanje izmedju tacaka i
	## smesta se u najnizi podatak registra xmm6.
	movaps xmm6, xmm4
	subps xmm6, xmm5
	mulps xmm6, xmm6
	movhlps xmm7, xmm6
	addss xmm6, xmm7
	movaps xmm7, xmm6
	shufps xmm7, xmm7, 0b01010101
	addss xmm6, xmm7
	sqrtss xmm6, xmm6
	
	## Uporedjuje se dobijeno rastojanje sa prethodnim najmanjim
	## rastojanjem.
	comiss xmm6, xmm3
	jae continue_inner

	## Ako je manje, tada se azuriraju rastojanje, kao i tacke u
	## xmm1 i xmm2.
	movss xmm3, xmm6
	movaps xmm1, xmm4
	movaps xmm2, xmm5
	
continue_inner:
	## Prelazimo na sledecu tacku u unutrasnjoj petlji.
	loop inner_loop

continue_outer:	
	## Vracamo vrednosti registara sa steka.
	pop ecx
	pop esi

        ## Prelazi se na sledecu tacku u spoljasnjoj petlji.
        loop outer_loop

        ## Upisuju se koordinate tacke A u za to predvidjene lokacije
        movups  [ebp-16], xmm1
        mov     ecx, 3
        lea     esi, [ebp-16]
        mov     edi, [ebp+16]
        rep movsd

	## Upisuju se koordinate tacke B u za to predvidjene lokacije
        movups  [ebp-16], xmm2
        mov     ecx, 3
        lea     esi, [ebp-16]
        mov     edi, [ebp+20]
        rep movsd

	## Upisuje se rastojanje izmedju tacaka A i B u za to predvidjenu
	## lokaciju.
	mov edi, [ebp+24]
        movss  [edi], xmm3
	
        ## Vraca se prethodni sadrzaj u registre koprocesora i SSE
        ## registre.
        fxrstor [esp]
        mov     esp, edx

done:
	## Epilog funkcije.
        pop     edi
        pop     esi
        pop     ebx
	leave
        ret
