#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include <string.h>

#define MAX_BUF 256 /* Velicina bafera */

/* Inline asembler implementacija funkcije strcat() */
char * inln_strcat(char *s, char *t)
{
  __asm__ __volatile__ 
    (
     "cld\n\t"   /* Postavljamo direction flag */
     "xorb %%al, %%al\n" /* Anuliramo al registar */
     
     /* Petlja u kojoj trazimo terminirajucu nulu u prvom stringu */
     "next_s:\n\t"
     "scasb\n\t"   
     "jne next_s\n\t"
     
     "decl %%edi\n" /* Vracamo se na poziciju terminirajuce nule */

     /* Petlja u kojoj nadovezujemo karaktere drugog stringa na prvi */
     "next_t:\n\t"
     "cmpb (%%esi), %%al\n\t" /* Sve dok nije terminirajuca nula */
     "je finish\n\t"
     "movsb\n\t"
     "jmp next_t\n"

     /* Na kraju terminiramo string nulom */
     "finish:\n\t"
     "stosb\n\t"
     
     :  /* Nema izlaznih parametara */ 
     : "D"(s),"S"(t)   /* Ulazni parametri: edi = s, esi = t */
     : "%eax"     /* Modifikovani registri: eax */
     );
  
  return s;
}

/* Test program */
int main()
{

  char s[MAX_BUF], t[MAX_BUF]; /* Nizovi u koje smestamo ucitane stringove */

  /* Ucitavamo stringove */
  scanf("%s %s", s, t);

  assert(strlen(s) + strlen(t) < MAX_BUF);

  /* Pozivamo funkciju i ispisujemo njen rezultat */
  printf("%s\n", inln_strcat(s,t));

  return EXIT_SUCCESS;
}
