.intel_syntax noprefix
        
.text
.global exp_rational

##########################################################################
##
## Funkcija:
##
## double exp_rational(int m, double *p, int n, double *q, double x);
##
## izracunava vrednost funkcije R(x) = P(x)/Q(x) gde je:
##
##	P(x) = p0 + p1*e^x+p2*e^(2x)+...+pm*e^(mx)
##	Q(x) = q0 + q1*e^x+q2*e^(2x)+...+qn*e^(nx)
##
## Argumenti funkcije su:
##
## -- int m -- [ebp+8] - stepen polinoma P
## -- double *p --  [ebp+12] - adresa niza koeficienata polinoma P
## -- int n -- [ebp+16] - stepen polinoma Q
## -- double *q --  [ebp+20] - adresa niza koeficienata polinoma Q
## -- double x  --  [ebp+24] - tacka u kojoj se racuna vrednost f-je.
##
## Funkcija vraca izracunatu vrednost. 
##
##########################################################################
exp_rational:
        ## Prolog funkcije.
	enter   0, 0
        push    esi

        ## Ucitava se vrednost za koju se racuna funkcija.
        fld qword ptr [ebp+24]  # Stek: x

	## Izracunava se t = e^x = 2^(x*log_2(e)) = 2^y
	fldl2e			# Stek: x,log_2(e)
	fmulp			# Stek: x*log_2(e) = y
	fld st(0)		# Stek: y, y
	frndint			# Stek  y, int(y)
	fsub st(1), st(0)	# Stek: y-int(y)=frac(y), int(y)
	fxch			# Stek: int(y),frac(y)
	f2xm1			# Stek: int(y),2^frac(y)-1
	fld1			# Stek: int(y),2^frac(y)-1,1
	faddp			# Stek: int(y),2^frac(y)
	fscale			# Stek: int(y),2^(frac(y)+int(y))=2^y
	fxch			# Stek: 2^y,int(y)
	fcomp			# Stek: 2^y = e^x = t

	
	## Izracunava se vrednost polinoma P(t) = p_0 + p_1*t + ... + p_m*t^m
	## Radi efikasnijeg racunanja, izraz se transformise u oblik:
        ##   P(t)=((...(0 * t + p_m)*t + p_{m-1})*t + p_{m-2})*t + ...)*t + p_0
        ## Registar esi ce sadrzati adresu tekuceg koeficienta polinoma
	## u brojiocu i inicijalizuje se na adresu koeficienta p_m.
	## Registar ecx se koristi kao brojac u petlji (imace pocetnu vrednost
	## m+1 jer je to broj iteracija).
        mov     ecx, [ebp+8]
        mov     esi, [ebp+12]
        mov     eax, ecx
	inc	ecx
        shl     eax, 3
        add     esi, eax

	## Inicijalna vrednost sume je 0.
	fldz			# Stek: t, 0 = S
next_p:
        fmul    st(0), st(1)    # Stek: t, S*t 
        fadd    qword ptr [esi] # Stek: t, S*t+p_i
        sub     esi, 8
				# Stek: t, S (nova vrednost sume)
        loop next_p

				# Stek: t, P(t)

	## Na slican nacin se izracunava vrednost polinoma Q(t) = q_0 + q_1*t
	## + ... + q_n*t^n. U registar ecx se ucitava n+1 (broj iteracija), a
	## u registar esi adresa koeficienta q_n.
        mov     ecx, [ebp+16]
        mov     esi, [ebp+20]
        mov     eax, ecx
        inc     ecx
        shl     eax, 3
        add     esi, eax

	## Inicijalna vrednost sume je 0.
	fldz			# Stek: t, P(t), 0 = S
next_q:
        fmul    st(0), st(2)    # Stek: t, P(t), S*t 
        fadd    qword ptr [esi] # Stek: t, P(t), S*t+q_i
        sub     esi, 8
				# Stek: t, P(t), S (nova vrednost sume)
        loop next_q

				# Stek: t, P(t), Q(t)
        
        
        fdivp                           # Stek: t, P(t)/Q(t)=R(t)
        fxch                            # Stek: R(t), t
        fcomp				# Stek: R(t)
        
	## Epilog funkcije.
        pop     esi
	leave
        ret
