.text
.align 2


.global nth_prime

@ Funkcija:
@
@ int nth_prime(int n);
@
@ racuna n-ti prost broj. Argument funkcije je:
@
@ r0 -- int n
@	
nth_prime:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Cuvamo na steku vrednosti registara koje cemo koristiti.
	stmfd sp!, {r4-r6}

	@ U r4 smestamo broj n
	mov r4, r0

	@ Slucaj n = 1
	cmp r4, #1
	moveq r0, #2
	beq done

	@ U suprotnom, u pitanju je neparan prost broj. Tekuci prost  
        @ broj (inicijalno 3) smestamo u r5. U r6 smestamo redni broj 
        @ tekuceg prostog broja (inicijalno 2).
	mov r6, #2
	mov r5, #3

next_number:
	@ Ako je brojac prostih brojeva jednak n, tada je broj u r5 
	@ upravo n-ti prost broj.
	cmp r6, r4
	beq last_number

	@ Proveravamo za sledeci neparan broj da li je prost.
	add r5, r5, #2

	@ Pozivamo pomocnu funkciju prime(k)
	mov r0, r5
	bl prime
	cmp r0, #1

	@ Ako jeste prost, tada uvecavamo brojac prostih brojeva.
	addeq r6, r6, #1
	b next_number
last_number:

	@ Smestamo rezultat u r0.
	mov r0, r5

done:
	@ Vracamo vrednosti registara koje smo koristili.
	ldmfd sp!, {r4-r6}
	
	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}


@ Funkcija:
@
@ int prime(int x);
@
@ odredjuje da li je broj x prost. Funkcija vreca 1 ako jeste, a 0 ako 
@ nije. Argument funkcije je:
@
@ -- r0 -- int x
@
prime:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Cuvamo vrednosti registara koje cemo koristiti
        stmfd sp!, {r4-r6}

	@ Smestamo u r4 broj x.
 	mov r4, r0

	@ Registar r5 ce nam biti tekuci broj k za koji ispitujemo da
	@ li deli x	
	mov r5, #1

	@ Registar r6 ce nam biti brojac delilaca broja x.
	mov r6, #0

next:
	@ Dokle god je k <= x
	cmp r5, r4
	bgt last
	
	@ Odredjujemo x % k
	mov r0, r4
	mov r1, r5
	bl __modsi3

	@ Ako je x % k == 0, uvecavamo brojac.
	cmp r0, #0
	addeq r6, r6, #1

	@ Uvecavamo k i prelazimo na sledecu iteraciju.
	add r5, r5, #1
	b next
last:

	@ Ako je broj delilaca 2, tada je broj prost. U suprotnom nije.
	cmp r6, #2
	moveq r0, #1
	movne r0, #0

	@ Vracamo sa steka vrednosti registara koje smo koristili.
	ldmfd sp!, {r4-r6}

	@ Epilog funkcije.
	mov sp, fp
	ldmfd sp!, {fp, pc}


