.intel_syntax noprefix

.text
.global local_min

##########################################################################
##
## Funkcija:
##
## int local_min(int * a, int n, int * b);
##
## odredjuje sve lokalne minimume niza a. Za element na poziciji i
## (1 <= i < n - 1) kazemo da je lokalni minimum ako su elementi
## a[i-1] i a[i+1] strogo veci od a[i]. Funkcija treba da u niz na koji
## pokazuje pokazivac b smesti redom sve indekse elemenata koji su lokalni
## minimumi (pocev od levog kraja niza). Funkcija vraca duzinu rezultujuceg
## niza indeksa. Argumenti funkcije su:
##
## -- int * a -- [ebp+8]  -- adresa pocetnog elementa niza
## -- int n   -- [ebp+12] -- duzina niza
## -- int *b  -- [ebp+16] -- adresa pocetnog elementa izlaznog niza
##
###########################################################################
local_min:
        ## Prolog funkcije.
        enter   0, 0
        push    ebx
        push    esi
        push    edi


	## Registar ecx ce sadrzati n - 2, tj. broj iteracija u petlji
	## zato sto ima ukupno n-2 unutrasnjih elemenata niza koji su
	## kandidati za lokalne minimume.
	mov ecx, [ebp + 12]
	sub ecx, 2

	## Ispitujemo da li je trivijalni slucaj, tj. da li je duzina
	## niza <= 2 (u tom slucaju nema lokalnih minumuma)
	xor eax, eax
	cmp ecx, 0
	jle done
	
	## Registar esi ce sadrzati adresu tekuceg elementa niza.
	mov esi, [ebp + 8]

	## Registar edx ce sadrzati adresu na koju treba upisati
	## sledeci element rezultujuceg niza.
	mov edx, [ebp + 16]
	
	## Registar edi ce u svakoj iteraciji sadrzati prethodni element,
	## eax ce sadrzati tekuci element, a ebx naredni element. Inicijalno
	## cemo u eax smestiti pocetni element niza, a u ebx naredni
	## (element sa indeksom 1).
	mov eax, [esi]
	mov ebx, [esi + 4]

	## Prelazimo na sledeci element
	add esi, 4
	
next_element:

	## Prebacujemo tekuci u prethodni, sledeci postavljamo na tekuci,
	## a naredni element niza ucitavamo u ebx
	mov edi, eax
	mov eax, ebx
	mov ebx, [esi + 4]

	## Ispitujemo da li je tekuci element lokalni minimum
	cmp eax, edi
	jl check_next
	jmp continue
check_next:
	cmp eax, ebx
	jl found_min
	jmp continue
	
found_min:
	## Izracunavamo indeks (razlika esi i adrese pocetka niza
	## podeljena sa 4) i postavljamo ga na kraj razultujuceg
	## niza.
	push esi
	sub esi, [ebp + 8]
	sar esi, 2
	mov [edx], esi
	add edx, 4
	pop esi

continue:	
	## Prelazimo na sledeci element
	add esi, 4	
	loop next_element
	

	## Odredjujemo duzinu rezultujuceg niza (tako sto oduzmemo
	## adresu pocetka niza od edx i podelimo sa 4).
	sub edx, [ebp + 16]
	sar edx, 2
	mov eax, edx
	
done:	
        ## Epilog funkcije.
        pop     edi
        pop     esi
        pop     ebx
        leave
        ret

