#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

/* Deklaracija funkcije centroid(). */
void centroid(double *x, double *y, double * z, int n, double *t);

int
main(void)
{
  int n;              /* Dimenzija prostora */
  double *x, *y, *z;   /* Pokazivaci na vektore koordinata tacaka x, y  i z*/
  double *t;           /* Pokazivac na vektor koordinata tezista t */
  int i;              /* Brojac u petljama */  

  /* Ucitavamo dimenziju */
  assert(scanf("%d", &n) == 1);
  
  /* Alociramo prostor */
  assert((x = malloc(sizeof(double)*n)) != NULL);
  assert((y = malloc(sizeof(double)*n)) != NULL);
  assert((z = malloc(sizeof(double)*n)) != NULL);
  assert((t = malloc(sizeof(double)*n)) != NULL);  

  /* Ucitavamo elemente vektora */
  for(i = 0;  i < n; i++)
    assert(scanf("%lf", &x[i]) == 1);
  for(i = 0;  i < n; i++)
    assert(scanf("%lf", &y[i]) == 1);
  for(i = 0;  i < n; i++)
    assert(scanf("%lf", &z[i]) == 1);


  /* Pozivamo funkciju */
  centroid(x, y, z, n, t);

  /* Prikazujemo rezultat */
  for(i = 0;  i < n; i++)
    printf("%f ", t[i]);
  printf("\n");
  
  /* Oslobadjamo prostor */
  free(x);
  free(y);
  free(z);
  free(t);
  
  return 0;
}
