.intel_syntax noprefix

.data

three:	.double 3.0, 3.0
	
.text
.global centroid

############################################################################
##
## Funkcija:
##
## void centroid(double *x, double *y, double * z, int n, double *t);
##
## izracunava teziste trougla XYZ u n-dimenzionom prostoru.
## Argumenti funkcije:
##
## -- double * x -- [ebp+8] -- adresa vektora koordinata tacke X
## -- double * y -- [ebp+12] -- adresa vektora koordinata tacke Y
## -- double * z -- [ebp+16] -- adresa vektora koordinata tacke Z
## -- int n --      [ebp+20] -- dimenzija prostora
## -- double * t -- [ebp+24] -- adresa vektora koordinata rezultata (tezista)
##
############################################################################
centroid:
        ## Prolog funkcije.
        enter   0, 0
        push    ebx
        push    esi
        push    edi

        ## Proverava se da li procesor podrzava SSE instrukcije.
        mov     eax, 1
        cpuid
        test    edx, 0x2000000
        jz not_supported

        ## Cuva se sadrzaj SSE registara i registara koprocesora.
        mov     edx, esp
        and     esp, 0xfffffff0
        sub     esp, 512
        fxsave  [esp]

	## U ecx smestamo dimenziju n. U esi smestamo adresu vektora
	## koordinata tacke X, u edi Y a u ebx Z. Registar eax ce
	## sadrzati adresu rezultujuceg vektora.
	mov ecx, [ebp+20]
	mov esi, [ebp+8]
	mov edi, [ebp+12]
	mov ebx, [ebp+16]
	mov eax, [ebp+24]
	
	## Registar xmm0 ce sadrzati 3,3
	movupd xmm0, three
next_two:
        ## Dokle god ima bar jos dva elementa...
        cmp     ecx, 2
        jb remaining

	## ...ucitavamo sledeca dva elemenata iz sva tri vektora, sabiramo
	## ih i delimo zbir sa tri. Nakon toga smestamo koordinate u
	## rezultujuci niz.
        movupd  xmm1, [esi]
        movupd  xmm2, [edi]
	movupd  xmm3, [ebx]
	addpd xmm1, xmm2
	addpd xmm1, xmm3
	divpd xmm1, xmm0
	movupd [eax], xmm1
        
        ## Prelazi se na narednu iteraciju.
        add     esi, 16
	add     edi, 16
	add     ebx, 16
	add     eax, 16
        sub     ecx, 2
        jmp next_two
        
remaining:
	## Ako je preostao jos jedan element...
        jecxz finish

	## ucitavamo preostale elemente vektora X, Y, Z, sabiramo ih, delimo
	## sa 3 i smestamo u rezultujuci vektor.
	movsd  xmm1, [esi]
        movsd  xmm2, [edi]
	movsd  xmm3, [ebx]
	addsd xmm1, xmm2
	addsd xmm1, xmm3
	divsd xmm1, xmm0
	movsd [eax], xmm1
finish:
	
        ## Vraca se prethodni sadrzaj u registre koprocesora i SSE
        ## registre.
        fxrstor [esp]
        mov     esp, edx

done:
	## Epilog funkcije.
        pop     edi
        pop     esi
        pop     ebx
	leave
        ret

not_supported:
	## Ako SSE instrukcije nisu podrzane, prekidamo program exit(1)
        ## pozivom.
        mov eax, 1
        mov ebx, 1
        int 0x80
