.intel_syntax noprefix

.data
one: .double 1.0
mask: .int 0xffffffff, 0x7fffffff, 0x0, 0x0
	
.text 
.global nth_root
#############################################################################
##
## Funkcija:
##
## void nth_root(double x, int n, double eps, double * r);
##
## racuna n-ti koren broja x vavilonskim metodom sa preciznoscu eps.
## U pitanju je iterativni metod x_{k+1} = 1/n*((n-1)x_k + x/x_k^(n-1)),
## pri cemu se za x_0 uzima proizvoljan broj (u nasem slucaju x_0 = 1).
## Iteracija se prekida kada je |x_{k+1} - x_k| < eps. Argumenti funkcije
## su:
## 
## -- double x 	 --  [ebp+8]  -- broj ciji se koren racuna
## -- int n      --  [ebp+16] -- koren koji racunamo
## -- double eps --  [ebp+20] -- trazena preciznost
## -- double * r --  [ebp+28] -- adresa na koju treba smestiti rezultat
##
############################################################################ 
nth_root:
	## Prolog funkcije
	enter 0,0
	push esi
	push edi
	
        ## Proverava se da li procesor podrzava SSE2 instrukcije.
        mov     eax, 1
        cpuid
        test    edx, 0x4000000
        jz not_supported

        ## Cuva se sadrzaj SSE registara (i registara koprocesora).
        mov     edx, esp
        and     esp, 0xfffffff0
        sub     esp, 512
        fxsave  [esp]

	## Ucitavamo n - 1 u eax
	mov eax, [ebp + 16]
	dec eax

	## Ucitavamo x u nizi podatak registra xmm0.
	movsd xmm0, [ebp + 8]

	## Ucitavamo eps u nizi podatak registra xmm1.
	movsd xmm1, [ebp + 20]

	## Ucitavamo n (uz konverziju u double) u nizi podatak registra xmm2.
	cvtsi2sd xmm2, [ebp + 16]

	## Registar xmm7 ce sadrzati masku za racunanje apsolutne vrednosti.
	movupd xmm7, mask
	
	## Registar xmm3 ce sadrzati prethodnu vrednost x_k na osnovu koje
	## racunamo sledecu. Inicijalno, za k = 0, x_0 = 1.
	movsd xmm3, one

next:
	## U registru xmm4 racunacemo sledecu vrednost k_{k+1} na osnovu
	## prethodne vrednosti x_k.
	
	## Najpre racunamo x_k^{n-1} u registru xmm5 (inicijalizujemo ga
	## na 1 = x_k^0)
	movsd xmm5, one

	## Petlja ce se izvrsiti n-1 put, pa zato ecx postavljamo na n-1.
	mov ecx, eax
	jecxz last_x
next_x:
	mulsd xmm5, xmm3
	loop next_x
last_x:	

	## Racunamo x/x_k^{n-1} u registru xmm4.
	movsd xmm4, xmm0
	divsd xmm4, xmm5

	## Dalje, racunamo (n-1)*x_k u registru xmm5
	movsd xmm5, xmm3
	movsd xmm6, xmm2
	subsd xmm6, one
	mulsd xmm5, xmm6

	## Najzad, sabiramo (n-1)*x_k + x/x_k^{n-1}, i delimo sve sa n.
	addsd xmm4, xmm5
	divsd xmm4, xmm2

	## Racunamo |x_{k+1} - x_{k}|
	subsd xmm3, xmm4
	andpd xmm3, xmm7

	## Uporedjujemo ovu razliku sa eps, i ako je manja, tada izlazimo
	## iz petlje.
	comisd xmm3, xmm1
	jb last

	## U suprotnom, azuriramo x_k (postavljamo ga na x_{k+1}, i prelazimo
	## na sledecu iteraciju.
	movsd xmm3, xmm4
	jmp next
last:	

	## Upisujemo poslednju izracunatu vrednost (xmm4) u lokaciju
	## predvidjenu za rezultat.
	mov eax, [ebp + 28]
	movsd [eax], xmm4
	
        ## Vraca se prethodni sadrzaj u registre koprocesora i SSE
	## registre.
        fxrstor [esp]
        mov     esp, edx

	## Epilog funkcije.
	pop edi
	pop esi
	leave
	ret

not_supported:
	## Ako SSE2 instrukcije nisu podrzane, prekidamo program exit(1)
	## pozivom. 
	mov eax, 1
	mov ebx, 1
	int 0x80
	