.intel_syntax noprefix
	
.text
.global happy

##########################################################################
##
## Funkcija:
##
## int happy(int x);
##
## ispituje da li je broj x "srecan" broj. "Srecni" brojevi se definisu na
## sledeci nacin: neka je data sekvenca x0, x1, x2, ..., pri cemu je x0=x,
## a x_i je jednak sumi kvadrata dekadnih cifara broja x_{i-1} (za i > 0).
## Broj ce biti "srecan" ako se njegova sekvenca zavrsava brojem 1 (jer su
## i svi ostali nakon njega u tom slucaju jednaki jedinici). U suprotnom,
## ako je sekvenca beskonacna (tj. ne sadrzi jedinicu), tada broj nije
## "srecan". Funkcija treba da vrati 1 ako je broj srecan, a 0 u suprotnom.
## Argument funkcije je:
##
## -- int x -- [ebp + 8] -- broj za koji ispitujemo da li je "srecan".
###########################################################################
happy:
        ## Prolog funkcije.
	enter 0,0
        push    ebx
        push    esi

	## Kopiramo vrednost broja x u registar eax. Ovaj registar ce
	## sadrzati tekuci broj u sekvenci (inicijalno x0 = x).
	## U registar ecx smestamo broj 10 (delicemo ovim brojem, da bismo
	## izdvajali dekadne cifre tekuceg broja u sekvenci).
	mov eax, [ebp + 8]
	mov ecx, 10

next_number:
	## Ako je tekuci broj jednak 1, tada je to kraj sekvence i pocetni
	## broj jeste "srecen" (vracamo upravo 1).
	cmp eax, 1
	je done

	## Ako je tekuci broj 4, tada smo usli u beskonacnu petlju, pa
	## broj nije "srecan" (vracamo 0).
	cmp eax, 4
	je failure

	## U suprotnom racunamo sledeci broj u sekvenci, kao zbir kvadrata
	## cifara tekuceg broja.

	## Registar esi ce nam sluziti za racunanje sume kvadrata cifara.
	xor esi, esi
next_digit:
	## Delimo broj sa 10, a zatim ostatak (iz registra edx) kvadriramo
	## i dodajemo na esi.
	xor edx, edx
	div ecx
	mov ebx, eax
	mov eax, edx
	mul eax
	add esi, eax

	## Ako smo izdvojili sve cifre, tada je zavrseno racunanje sume, u
	## suprotnom prelazimo na sledecu cifru.
	mov eax, ebx
	cmp eax, 0
	je last_digit
	jmp next_digit
last_digit:	

	## Kopiramo esi u eax -- to nam je sledeci broj u sekvenci.
	mov eax, esi
	jmp next_number

failure:
	mov eax, 0
	
done:	
	## Epilog funkcije
	pop esi
	pop ebx
	leave
	ret
	