.text
.align 2


.global digits

@ Funkcija:
@
@ void digits(int n, int * l, int * g);
@
@ odredjuje najmanju i najvecu cifru u dekadnom zapisu broja n > 0. 
@ Argumenti funkcije su:
@
@ int n   -- r0 --  dati broj n.
@ int * l -- r1 --  adresa na koju treba upisati najmanju cifru
@ int * g -- r2 --  adresa na koju treba upisati najvecu cifru
@
digits:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Cuvamo na steku registre koje cemo da koristimo.
	stmfd sp!, {r4-r8} 

	@ U r4 smestamo broj n
	mov r4, r0

	@ r5 ce nam cuvati najmanju, a r6 najvecu cifru. Inicijalizujemo
	@ ih na 0.
	mov r5, #0
	mov r6, #0

	@ Kopiramo adresu l u r7, a adresu g u r8.
	mov r7, r1
	mov r8, r2

	@ Ako je broj n == 0, preskacemo petlju.
	cmp r4, #0
	beq last_digit

	@ U suprotnom inicijalizujemo najmanju cifru na 9. Svaki put 
	@ kada naidjemo na manju cifru, ova vrednost ce biti azurirana.
	@ Najveca cifra ostaje 0, i bice azurirana svaki put kada 
	@ naidjemo na vecu cifru.
	mov r5, #9

next_digit:
	@ Odredjujemo ostatak pri deljenju sa 10 (to je poslednja 
	@ dekadna cifra)
	mov r0, r4
	mov r1, #10
	bl __modsi3
	
	@ Proveravamo da li je tekuca cifra manja od do sada najmanje
	@ koja se nalazi u registru r5, i po potrebi je azuriramo.
	cmp r0, r5
	movlt r5, r0

	@ Proveravamo da li je tekuca cifra veca od do sada najvece
	@ koja se nalazi u registru r6, i po potrebi je azuriramo.
	cmp r0, r6
	movgt r6, r0
	
	@ Delimo broj sa 10, kako bismo ga pripremili za izdvajanje 
        @ sledece cifre.
	mov r0, r4
	mov r1, #10
	bl __divsi3
	mov r4, r0	

	@ Ako je kolicnik 0, tada nema vise cifara. U suprotnom idemo na
	@ sledecu iteraciju.
	cmp r4, #0
	bne next_digit
last_digit:

	@ Upisujemo najmanju cifru na za to predvidjenu lokaciju.
	str r5, [r7]
	
	@ Upisujemo najvecu cifru na za to predvidjenu lokaciju.
	str r6, [r8]


	@ Skidamo sa steka vrednosti registara koje smo koristili.
	ldmfd sp!, {r4-r8}

	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}
