#include <stdio.h>
#include <stdlib.h>

#define MAX_ARRAY 80

/* Funkcija koja je kompatibilna sa memcpy() funkcijom
   standardne bibiloteke */
void * inln_memcpy(void * dest, void * src, int nbytes);

int main()
{
  int x[MAX_ARRAY];
  int y[MAX_ARRAY];
  int n;
  int i;

  /* Ucitavamo broj elemenata, i same 
     elemente niza */
  scanf("%d", &n);
  for(i = 0; i < n;  i++)
   scanf("%d", &x[i]);

  /* Kopiramo niz x u niz y */
  inln_memcpy(y,x, sizeof(x));

  /* Ispisujemo elemente niza y */
  for(i = 0; i < n; i++)
   printf("%d ",y[i]);
 
  printf("\n");

  return EXIT_SUCCESS;
}


void * inln_memcpy(void *dest, void *src, int nbytes)
{
   __asm__ __volatile__(
   "cld\n\t"                          /* Resetujemo DF */
   "rep movsb\n\t"                    /* Kopiramo niz  */
   : 
   : "S"(src), "D"(dest), "c"(nbytes) /* Alociramo esi za src,
                                         edi za dest, ecx za nbytes. */
   );

   return dest;
}
