.intel_syntax noprefix

.text
.global concat

##########################################################################
##
## Funkcija:
##    unsigned concat(unsigned x, unsigned y);
##
##  izracunava vrednost broja nastalog nadovezivanjem dekadnih zapisa
##  brojeva x i y. Argumenti funkcije su:
##
## -- unsigned x -- [ebp + 8]
## -- unsigned y -- [ebp + 12]
##
## Funkcija vraca izracunatu vrednost.
##
##########################################################################
concat:
        ## Prolog funkcije.
        enter   0, 0
	push ebx
	
	## Registar ebx ce sadrzati broj 10
	mov ebx, 10
	
	## Najpre cemo na stek postaviti cifre drugog broja, pocev od cifre
	## najmanje tezine, tj. cifra najvece tezine bice na vrhu steka.

	## Registar eax ce sadrzati tekucu vrednost drugog broja.
	mov eax, [ebp + 12]

	## Registar ecx ce biti brojac cifara na steku.
	xor ecx, ecx
next_digit:
	cmp eax, 0
	je last_digit

	## Delimo sa 10 i postavljamo cifru na stek, a zatim uvecavamo brojac.
	xor edx, edx
	div ebx
	push edx
	inc ecx
	
	jmp next_digit
last_digit:	

	## Sada skidamo sa steka cifre i utiskujemo ih u prvi broj sa desne
	## strane.
	mov eax, [ebp + 8]
next_mul:
	mul ebx
	pop edx
	add eax, edx
	loop next_mul

	pop ebx
	leave
        ret


