.text
.align 2


.global vowels

@ Funkcija:
@
@ void vowels(char * s, char * c, int * f);
@
@ odredjuje najfrekventniji samoglasnik u stringu s, kao i broj njegovih 
@ pojavljivanja. Argument funkcije je:
@
@ r0 -- char * s -- adresa pocetka stringa
@ r1 -- char * c -- lokacija na koju treba upisati nadjeni karakter
@ r2 -- int * f  -- lokacija na koju treba upisati frekvenciju
@
vowels:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Cuvamo na steku vrednosti registara koje cemo koristiti.
	stmfd sp!, {r6-r10}

	@ Registri r6 - r10 ce nam biti brojaci samoglasnika:
	@ r6 -  brojac karaktera 'a' (ili 'A')
	@ r7 -  brojac karaktera 'e' (ili 'E')
	@ r8 -  brojac karaktera 'i' (ili 'I')
	@ r9 -  brojac karaktera 'o' (ili 'O')
	@ r10 - brojac karaktera 'u' (ili 'U')
	@ Sve ih inicijalno postavljamo na 0.
	mov r6, #0
	mov r7, #0
	mov r8, #0
	mov r9, #0
	mov r10, #0


next_char:
	@ Ucitavamo neoznaceni bajt sa adrese r0 i pomeramo pokazivac u 
	@ desno.
	ldrb r3, [r0], #1

	@ Ako je dati karakter jednak nuli, izlazimo iz petlje, a u 
	@ suprotnom uvecavamo brojac.
	cmp r3, #0
	beq last_char

	@ U nastavku testiramo ucitani karakter na jednakost sa 
	@ samoglasnicima (velikim i malim). Ako je neka od jednakosti
	@ ispunjena, uvecava se odgovarajuci brojac.

	cmp r3, #'a'
	addeq r6, r6, #1
	beq continue

	cmp r3, #'A'
	addeq r6, r6, #1
	beq continue

	cmp r3, #'e'
	addeq r7, r7, #1
	beq continue

	cmp r3, #'E'
	addeq r7, r7, #1
	beq continue

	cmp r3, #'i'
	addeq r8, r8, #1
	beq continue

	cmp r3, #'I'
	addeq r8, r8, #1
	beq continue

	cmp r3, #'o'
	addeq r9, r9, #1
	beq continue

	cmp r3, #'O'
	addeq r9, r9, #1
	beq continue

	cmp r3, #'u'
	addeq r10, r10, #1
	beq continue

	cmp r3, #'U'
	addeq r10, r10, #1

continue:
	@ Prelazimo na sledeci karakter.
	b next_char

last_char:
	
	@ Izracunavamo najvecu od vrednosti registara r6-r10 i smestamo 
	@ je u r3. Vrednost odgovarajuceg karaktera smestamo u r0.

	mov r3, r6
	mov r0, #'a'

	cmp r7, r3
	movgt r3, r7
	movgt r0, #'e'

	cmp r8, r3
	movgt r3, r8
	movgt r0, #'i'

	cmp r9, r3
	movgt r3, r9
	movgt r0, #'o'

	cmp r10, r3
	movgt r3, r10
	movgt r0, #'u'

	@ Smestamo podatke na za to predvidjene lokacije.
	strb r0, [r1]
	str r3, [r2]


	@ Vracamo sa steka vrednosti registara koje smo koristili.
	ldmfd sp!, {r6-r10}
	
	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}
