.text
.align 2

.global binom

@ Funkcija:
@
@ int binom(int n, int k);
@ 
@ izracunava binomni koeficient (n k). Argumenti funkcije su:
@
@ -- r0 -- int n
@ -- r1 -- int k
@
binom:

	@ Prolog funkcije
	stmfd sp!, {fp,lr}
	mov fp, sp

	@ Smestamo na stek vrednosti registara koje cemo koristiti.
	stmfd sp!, {r4-r6}

	@ Cuvamo n u r4, a k u r5.
	mov r4, r0
	mov r5, r1

	@ Izlaz iz rekurzije:  binom(n,0) = binom(n,n) = 1.
	cmp r5, #0
	moveq r0, #1
	beq done
	cmp r5, r4
	moveq r0, #1
	beq done

	@ Pozivamo binom(n-1, k-1)
	sub r0, r4, #1
	sub r1, r5, #1
	bl binom

	@ Cuvamo povratnu vrednost rekurzivnog poziva u  r6
	mov r6, r0
	
	@ Pozivamo binom(n-1, k)
	sub r0, r4, #1
	mov r1, r5
	bl binom

	@ Sabiramo rezultate dva prethodna rekurzivna poziva.
	add r0, r0, r6

done:

	@ Skidamo sa steka vrednosti registra koje smo koristili.
	ldmfd sp!, {r4-r6}

	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp,pc}
