.text
.align 2


.global ackerman

@ Funkcija:
@
@ void ackerman(int a, int b, int * x, int * l);
@
@ odredjuje broj iz intervala [a,b] sa najduzom Ackerman-ovom sekvencom.
@ Argumenti funkcije su:
@
@ -- r0 -- int a -- leva granica intervala
@ -- r1 -- int b -- desna granica intervala
@ -- r2 -- int * x -- lokacija na koju se upisuje nadjeni broj.
@ -- r3 -- int * l -- lokacija na koju se upisuje duzina sekvence 
@                     nadjenog broja.
@	
ackerman:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Cuvamo na steku vrednosti registara koje cemo koristiti.
	stmfd sp!, {r4-r10}

	@ U registar r4 smestamo levu granicu intervala.
	mov r4, r0	
	@ U registar r5 smestamo desnu granicu intervala.
	mov r5, r1
	@ U registar r6 smestamo lokaciju za broj x.
	mov r6, r2
	@ U registar r7 smestamo lokaciju za duzinu sekvence l. 
	mov r7, r3

	@ Registar r8 ce biti broj cija je sekvenca do sada najduza.
	@ Inicijalizujemo ga na vrednost a.
	mov r8, r4
	
	@ Registar r9 ce biti duzina do sada najduze sekvence.
	@ Inicijalizujemo je na sequence(a).
	mov r0, r4
	bl sequence
	mov r9, r0

	@ Registar r10 ce biti tekuci broj iz intervala [a,b]
	@ Inicijalizujemo ga na x = a + 1
	add r10, r4, #1

next_number:
	@ Dokle god je x <= b
	cmp r10, r5
	bgt last_number

	@ Pozivamo sequence(x)
	mov r0, r10
	bl sequence

	@ Ako je sekvenca broja x duza od do sada najduze, tada
	@ azuriramo vrednosti r9 i r8.
	cmp r0, r9
	movgt r9, r0
	movgt r8, r10	

	@ Uvecavamo brojac i prelazimo na sledecu iteraciju.
	add r10, r10, #1
	b next_number
last_number:
	
	@ Smestamo rezultate na za to predvidjene lokacije.
	str r8, [r6]
	str r9, [r7]


	@ Vracamo vrednosti registara koje smo koristili.
	ldmfd sp!, {r4-r10}
	

	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}


@ Funkcija:
@
@ int sequence(int x);
@ 
@ vraca duzinu Ackerman-ove sekvence broja x. Argument funkcije je:
@
@ -- r0 -- int x.
@
sequence:

	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ r1 ce biti brojac u kome se izracunava duzina sekvence.
	mov r1, #0

next_iter:
	@ Dokle god se ne stigne do jedinice
	cmp r0, #1
	beq last_iter

	@ Testiramo bit najmanje tezine, cime utvrdjujemo parnost broja.
	tst r0, #1

	@ Ako je parno, tada je sledece x = x/2
	moveq r0, r0, lsr #1

	@ Ako je neparno, tada je sledece x = 3 * x + 1
	movne r2, r0
	movne r3, #3
	mulne r0, r2, r3
	addne r0, r0, #1 

	@ Uvecavamo duzinu sekvence za jedan, i prelazimo na sledecu
	@ iteraciju.
	add r1, r1, #1
	b next_iter

last_iter:

	@ Smestamo rezultat u r0	
	mov r0, r1

	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}

