#include <stdio.h>

/* NAPOMENA: Programski jezik C (kao i njegov naslednik C++) prilikom 
   prevodjenja primenjuje princip obavezne prethodne deklaracije, sto
   znaci da svaki objekat mora biti deklarisan u nekom fajlu pre upotrebe
   u tom istom fajlu sa C kodom. Da bi se obezbedilo da C kod moze da
   koristi funkcije i podatke koji su definisani u nekom drugom fajlu (a
   deo su istog projekta), ili su definisani u istom fajlu, ali negde ispod,
   uvodi se pojam DEKLARACIJE. Deklaracijom se prevodiocu stavlja do znanja
   da postoji objekat (podatak ili funkcija) na globalnom nivou koji ima
   odredjeno ime i odredjeni tip. Svaka definicija je ujedno i deklaracija,
   medjutim, postoje i DEKLARACIJE BEZ DEFINICIJE ("bez definicije" znaci
   da ne rezervisu prostor (u slucaju podataka), odnosno da ne definisu 
   algoritam (u slucaju funkcije)). Deklaracija funkcije (koja se zove i
   prototip funkcije) se sastoji iz zaglavlja funkcije za kojim sledi znak
   ; (bez tela funkcije). Npr:
   
   int f();
   void g(int x, int y);

   Deklaracija (bez definicije) podatka se zadaje na sledeci nacin:
   
   extern int x;
   extern float y;

   Kljucna rec extern sprecava alociranje prostora u memoriji za ove globalne
   objekte. Time se samo obavestava prevodilac da postoje promenljive ovih
   tipova sa ovim imenima. Na programeru je odgovornost da ove promenljive
   zaista negde i definise (ili u istom fajlu, samo nize, ili u nekom drugom
   fajlu). Kljucna rec extern se moze koristiti i kod funkcija, mada nije 
   neophodna (jer je jesno da je u pitanju samo deklaracija, s obzirom da
   nema telo). 

   Svaki globalni objekat (funkcija ili podatak) mora biti definisan TACNO 
   JEDNOM u celom projektu (dakle, samo u jednom od fajlova koji ucestvuju
   u projektu).
*/

/* Deklaracija funkcije (definicija je dole) */
void obrni(int * a, int n);

/* Program demonstrira obrtanje niza */
int main()
{
  int a[100];
  int n, *p;

  scanf("%d", &n);
  for(p = a; p < a + n; p++)
    {
      scanf("%d", p);
    }

  printf("Niz pre obrtanja: ");
  for(p = a; p < a + n; p++)
    {
      printf("%d ", *p);
    }
  
  /* Funkcija obrce niz */
  obrni(a, n);

    
  printf("Niz posle obrtanja: ");
  for(p = a; p < a + n; p++)
  {
    printf("%d ", *p);
  }
  

  return 0;
}

/* Definicija funkcije */
void obrni(int * a, int n)
{
  int *p, *q;

  /* Bitno je napomenuti da se nizovi uvek prenose po adresi, tj. pomocu 
     pokazivaca, sto za posledicu ima direktno baratanje sa originalnim
     nizom iz pozivajuce funkcije. Sve promene koje izvrsimo na nizu u 
     telu funkcije ostaju trajno vidljive i pozivajucoj funkciji */
  for(p = a, q = a + n - 1; p < q; p++, q--)
    {
      int t = *p; 
      *p = *q;
      *q = t;
    }
  
}

