#include <stdio.h>

/* NAPOMENA: Funkcija ne moze imati parametre nizovskog tipa, niti moze
   vracati niz kao povratnu vrednost. Medjutim, funkcija moze da prihvata
   pokazivac, kao i da vraca pokazivac, tako da se na taj nacin moze 
   manipulisati ni nizovima. Standardni nacin je da se funkciji preda 
   pokazivac na pocetni element niza, kao i broj njegovih elemenata (kao
   drugi parametar). Funkcija moze u svom telu da pristupa elementima niza
   na uobicajen nacin. */

/* Funkcija racuna prosek elemenata niza */
double prosek(int * a, int n)
{
  int i;
  int S = 0;

  /* Koristimo indeksnu sintaksu -- a pokazuje na pocetni element, pa je
     a[i] element na poziciji i u nizu */
  for(i = 0; i < n; i++)
    S += a[i];

  return (double) S / n;
}

/* Druga verzija */
double prosek2(int * a, int n)
{
  int m;
  int S = 0;

  /* Koristimo pokazivacku sintaksu -- a inicijalno pokazuje na pocetni 
     element, a zatim ga u svakoj iteraciji pomeramo u desno, prelazeci
     na sledeci element (kome pristupamo sa *a) */
  for(m = n; m; a++, m--)
    S += *a;

  return (double) S / n;
}

/* Treca verzija */
double prosek3(int a[], int n)
{
  int m;
  int S = 0;

  /* U trecoj verziji, parametar funkcije je deklarisan kao int a[], 
     medjutim, prevodilac to interno tumaci kao int *a. Naime, prevodilac
     dopusta (zbog fleksibilnosti i udobnosti) da programer definise 
     parametar nizovskog tipa, ali ga interno uvek "popravlja" u 
     pokazivacki tip. Cak i da smo naveli dimenziju (int a[100]), prevodilac
     bi to interno i dalje tumacio kao int * a. */
  for(m = n; m; a++, m--)
    S += *a;

  return (double) S / n;
}


/* Program racuna prosek celih brojeva unetih na ulazu */
int main()
{
  int a[100], *p;
  int n, i; 
  int S = 0;

  scanf("%d", &n);


  for(p = a; p < a + n; p++)
    scanf("%d", p);
 
  printf("%f\n", prosek(a, n));

  return 0;
}
