.intel_syntax noprefix

.data
zero:   .double  0               # Broj 0.
        
.text
.global standard_deviation

	## Funkcija standard_deviation() izracunava standardnu
        ## devijaciju za dati niz vrednosti.  Argumenti funkcije su:
        ##   [ebp+8] - broj vrijednosti u datom nizu
        ##   [ebp+12] - adresa na kojoj pocinje niz
        ##   [ebp+16] - adresa na koju treba upisati izracunatu
	##              standardnu devijaciju
        ## Pretpostavka je da su u nizu zadate bar dve vrednosti.
        ## Funkcija se u potpunosti podvrgava C konvencijama pozivanja.
standard_deviation:
        ## Prolog funkcije.
	enter           0, 0
        push            esi
        push            edi

        ## Proverava se da li procesor podrzava SSE2 instrukcije.
        mov             eax, 1
        cpuid
        test            edx, 0x4000000
        jz done

        ## Cuva se sadrzaj SSE registara i registara koprocesora.
        mov             edx, esp
        and             esp, 0xfffffff0
        sub             esp, 512
        fxsave          [esp]

        ## Registar eax ce cuvati broj elemenata datog vektora.
        mov             eax, [ebp+8]

        ## Izracunava se srednja vrijednost datog vektora.  Sabiranje
        ## elemenata vektora ce biti vrseno za po 2 elementa istovremeno
        ## i parcijalni zbirovi ce biti cuvani u registru xmm0.
        ## Registar esi ce sadrzati adresu prvog narednog elementa
	## vektora. Registar ecx ce biti koriscen kao brojac.
        movsd           xmm0, zero
        shufpd          xmm0, xmm0, 0b00
        mov             esi, [ebp+12]        
        mov             ecx, eax
mean_next2:
        ## Ako je preostalo 2 ili vise elemenata datog vektora,
        ## uracunavaju se isti u parcijalne sume, registar esi se
        ## postavlja na adresu prvog narednog elementa vektora, a brojac
	## se umanjuje za 2.
        cmp             ecx, 2
        jl mean_next1
        movupd          xmm1, [esi]
        addpd           xmm0, xmm1
        add             esi, 16
        sub             ecx, 2
        jmp mean_next2

mean_next1:
        ## Dodaje se na nizu parcijalnu sumu preostali element vektora,
	## ako postoji.
	jecxz mean_final_sum
        movsd           xmm1, [esi]
        addsd           xmm0, xmm1

mean_final_sum:	
        ## Sabiraju se parcijalne sume i potom se izracunava srednja
        ## vrednost elemenata vektora i smesta u oba polja registra
	## xmm7.
	movapd		xmm1, xmm0
        shufpd          xmm1, xmm1, 0b01
        addsd           xmm0, xmm1
        cvtsi2sd        xmm1, eax
        divsd           xmm0, xmm1
        shufpd          xmm0, xmm0, 0b00
        movapd          xmm7, xmm0

        ## Parcijalne sume za racunanje standardne devijacije se
        ## formiraju na potpuno isti nacin kao parcijalne sume za
	## racunanje srednje vrednosti.
        movsd           xmm0, zero
        shufpd          xmm0, xmm0, 0b00
        mov             esi, [ebp+12]
        mov             ecx, eax
deviation_next2:
        ## Ako je preostalo 2 ili vise elemenata datog vektora,
        ## uracunavaju se isti u parcijalne sume, registar esi se
        ## postavlja na adresu prvog narednog elementa vektora, a brojac
	## se umanjuje za 2.
        cmp             ecx, 2
        jl deviation_next1
        movupd          xmm1, [esi]
        subpd           xmm1, xmm7
        mulpd           xmm1, xmm1
        addpd           xmm0, xmm1
        add             esi, 16
        sub             ecx, 2
        jmp deviation_next2

deviation_next1:
        ## Dodaje se na nizu parcijalnu sumu preostali element vektora,
	## ako postoji.
	jecxz deviation_final_sum
        movsd           xmm1, [esi]
        subsd           xmm1, xmm7
        mulsd           xmm1, xmm1
        addsd           xmm0, xmm1

deviation_final_sum:	
        ## Sabiraju se parcijalne sume i potom se izracunava vrednost
        ## devijacije.
        movapd		xmm1, xmm0
        shufpd          xmm1, xmm1, 0b01
        addsd           xmm0, xmm1
        dec             eax
        cvtsi2sd        xmm1, eax
        divsd           xmm0, xmm1
        sqrtsd          xmm0, xmm0

        ## Smesta se izracunata vrednost u za to predvidjenu
	## memorijsku lokaciju.
        mov             edi, [ebp+16]
        movsd           [edi], xmm0        
        
        ## Vraca se prethodni sadrzaj u registre koprocesora i SSE
        ## registre.
        fxrstor         [esp]
        mov             esp, edx

done:        
	## Epilog funkcije.
        pop             edi
        pop             esi
	leave
        ret
