.intel_syntax noprefix

.data
one:	.double 1.0
	
.text
.global epowx

############################################################################# 
##
## void epowx (double x, int n, double * r); 
##
## double x  -- [ebp+8] -- tacka u kojoj racunamo vrednost funkcije
## int n     -- [ebp+16] -- stepen polinoma za aproksimaciju
## double *r -- [ebp+20] -- adresa na koju se upisuje rezultat
#############################################################################
epowx:
	## Prolog funkcije
	enter 0,0
	push edi

	## Proverava se da li procesor podrzava SSE2 instrukcije.
        mov     eax, 1
        cpuid
        test    edx, 0x4000000
        jz not_supported

	## Cuva se sadrzaj SSE registara (i registara koprocesora).
        mov     edx, esp
        and     esp, 0xfffffff0
        sub     esp, 512
        fxsave  [esp]

	
	## NAPOMENA: u komentarima cemo za opis sadrzaja SSE registara
	## koristiti notaciju (x0, x1), gde je x0 double vrednost u nizem
	## delu registra, dok je x1 double vrednost u visem delu registra.

	
	## U registar xmm0 smestamo par (1, x). Ovaj registar ce nam sadrzati
	## sledeca dva sabirka koja treba dodati na sumu. U registar ecx
	## smestamo vrednost n + 1 (broj sabiraka u polinomu stepena
	## n).
	movlpd xmm0, one
	movhpd xmm0, [ebp + 8]
	mov ecx, [ebp + 16]
	inc ecx
	
	## U registar xmm7 smestamo par (1,1).
	movapd xmm7, xmm0
	shufpd xmm7, xmm7, 0b00

	## U registar xmm6 smestamo (x^2, x^2). Ove vrednosti ce nam biti
	## potrebne da u kasnijim iteracijama od prethodna dva sabirka
	## mnozenjem sa x^2 dobijemo sledeca dva. 
	movapd xmm6, xmm0
	shufpd xmm6, xmm6, 0b11
	mulpd xmm6, xmm6

	## U registar xmm3 smestamo par (0, 1), a u registar xmm2 smestamo
	## par (-1, 0). Ove dva registra ce nam biti potrebni kako bismo
	## efikasno racunali faktorijele kojim delimo stepen od x. Naime,
	## ako imamo par (x^(k-1)/(k-1)!, x^k/k!), u sledecoj iteraciji bi
	## trebalo dobiti par (x^(k+1)/(k+1)!, x^(k+2)/(k+2)!), sto mozemo
	## dobiti tako sto pomnozimo oba sa x^2 a zatim podelimo prvi sa
	## k i sa k+1, dok drugi podelimo sa k+1 i k+2. Zato ce nam registar
	## xmm3 cuvati (k-1,k) a registar xmm2 par (k-2,k-1),
	## tj. poslednje i pretposlednje vrednosti kojima su deljeni tekuci
	## sabirci. Za sledecu iteraciju samo treba uvecati sve cetiri
	## vrednosti za 2 cime se dobijaju (k+1,k+2) i (k,k+1), a zatim se
	## ovim registrima podele vrednosti sabiraka.
	movsd xmm3, one  ## anulira se visi deo registra
	shufpd xmm3, xmm3, 0b01
	movapd xmm2, xmm3
	subpd xmm2, xmm7

	## U registar xmm7 smestamo par (2,2) dupliranjem prethondih
	## vrednosti. Vrednost ovog registra cemo dodavati na xmm2 i xmm3
	## kako bismo odgovarajuce vrednosti u njima uvecavali za 2.
	addpd xmm7, xmm7

	## Registar xmm1 postavljamo na (0,0). Ovaj registar ce nam sadrzati
	## sumu parnih odn. neparnih clanova sume.
	xorpd xmm1, xmm1
	
next_two:
	## Ako je preostalo manje od dva, izlazimo iz petlje.
	cmp ecx, 2
	jl remaining

	## Dodajemo sledeca dva sabirka na parcijalne sume.
	addpd xmm1, xmm0

	## Pripremamo sledeca dva sabirka. Najpre uvecavamo
	## registre xmm2 i xmm3 za po dva.
	addpd xmm2, xmm7
	addpd xmm3, xmm7

	## Mnozimo tekuce sabirke sa x^2 i delimo ih odgovarajucim
	## proizvodima.
	mulpd xmm0, xmm6
	divpd xmm0, xmm2
	divpd xmm0, xmm3

	## Prelazimo na sledeca dva sabirka.
	sub ecx, 2
	jmp next_two

remaining:
	## Ako je preostao jos jedan sabirak, dodajemo ga na nizu sumu.
	jecxz finish
	addsd xmm1, xmm0

finish:
	## Racunamo konacnu sumu i smestamo je u za to predvidjenu lokaciju.
	movapd xmm0, xmm1
	shufpd xmm1, xmm1, 0b01
	addsd xmm0, xmm1
	mov edi, [ebp + 20]
	movsd [edi], xmm0

	
	## Vraca se prethodni sadrzaj u registre koprocesora i SSE
	## registre.
        fxrstor [esp]
        mov     esp, edx
		
done:
	## Epilog funkcije.
	pop edi
	leave
	ret
	
not_supported:
	## Ako SSE2 instrukcije nisu podrzane, prekidamo program exit(1)
	## pozivom. 
	mov eax, 1
	mov ebx, 1
	int 0x80
	