#include <stdio.h>

#define MAX 100

/* Funkcija sortira niz celih brojeva metodom sortiranja izborom 
   najmanjeg elementa: U prvoj iteraciji se trazi najmanji element 
   u nizu i postavlja se na pocetnu poziciju (zamenom sa elementom
   koji se na toj poziciji nalazio ranije). U sledecoj iteraciji se
   trazi najmanji element medju preostalim elementima, i postavlja se
   na sledecu poziciju, itd. */
void selection_sort (int a[], int n)
{
  int i, j;
  int min;
  int pom;

  /* U svakoj iteraciji ove petlje se pronalazi najmanji element medju
     elementima a[i], a[i+1],...,a[n-1], i postavlja se na poziciju i,
     dok se element na pozciji i premesta na poziciju min, na kojoj se
     nalazio najmanji od gore navedenih elemenata. */
  for (i = 0; i < n - 1; i++)
    {
      /* Unutrasnja petlja pronalazi poziciju min, na kojoj se nalazi
         najmanji od elemenata a[i],...,a[n-1]. */
      min = i;
      for (j = i + 1; j < n; j++)
	if (a[j] < a[min])
	  min = j;

      /* Zamena elemenata na pozicijama (i) i min. Ovo se radi samo ako
         su (i) i min razliciti, inace je nepotrebno. */
      if (min != i)
	{
	  pom = a[i];
	  a[i] = a[min];
	  a[min] = pom;
	}
    }

}


/* Funkcija sortira niz celih brojeva metodom sortiranja umetanjem.
   Ideja algoritma je sledeca: neka je na pocetku i-te iteracije niz
   prvih i elemenata (a[0],a[1],...,a[i-1]) sortirano. U i-toj 
   iteraciji zelimo da element a[i] umetnemo na pravu poziciju medju
   prvih i elemenata tako da dobijemo niz duzine i+1 koji je sortiran.
   Ovo radimo tako sto i-ti element najpre uporedimo sa njegovim prvim
   levim susedom (a[i-1]). Ako je a[i] vece, tada je on vec na pravom
   mestu, i niz a[0],a[1],...,a[i] je sortiran, pa mozemo preci na 
   sledecu iteraciju. Ako je a[i-1] vece, tada zamenjujemo a[i] i a[i-1],
   a zatim proveravamo da li je potrebno dalje potiskivanje elementa
   u levo, poredeci ga sa njegovim novim levim susedom. Ovim uzastopnim 
   premestanjem se a[i] umece na pravo mesto u nizu. */
void insertion_sort(int a[], int n)
{
  int i, j;
  
  /* Na pocetku iteracije pretpostavljamo da je niz a[0],...,a[i-1]
     sortiran */
  for(i = 1; i < n; i++)
    {
      
      /* U ovoj petlji redom potiskujemo element a[i] u levo koliko
	 je potrebno, dok ne zauzme pravo mesto, tako da niz 
	 a[0],...a[i] bude sortiran. Indeks j je trenutna pozicija
	 na kojoj se element koji umecemo nalazi. Petlja se zavrsava
	 ili kada element dodje do levog kraja (j==0) ili dok ne 
	 naidjemo na element a[j-1] koji je manji od a[j]. */
      for(j = i; j > 0 && a[j] < a[j - 1]; j--)
	{
	  int temp = a[j];
	  a[j] = a[j - 1];
	  a[j - 1] = temp;
	}
    }
  
}


/* Funkcija sortira niz celih brojeva metodom mehurica.
   Ideja algoritma je sledeca: prolazimo kroz niz redom
   poredeci susedne elemente, i pri tom ih zamenjujuci 
   ako su u pogresnom poretku. Ovim se najveci element
   poput mehurica istiskuje na "povrsinu", tj. na krajnju 
   desnu poziciju. Nakon toga je potrebno ovaj postupak 
   ponoviti nad nizom a[0],...,a[n-2], tj. nad prvih n-1
   elemenata niza bez poslednjeg koji je postavljen na 
   pravu poziciju. Nakon toga se istu postupak ponavlja nad
   sve kracim i kracim prefiksima niza, cime se jedan po 
   jedan istiskuju elemenenti na svoje prave pozicije.
*/
void bubble_sort(int a[], int n)
{
  int i, j;
  int ind;
  
  for(i = n , ind = 1 ; i > 1 && ind ; i--)
    
    /* poput "mehurica" potiskujemo najveci element medju elementima
       od a[0] do a[i-1] na poziciju i-1 uporedjujuci susedne elemente 
       niza i potiskujuci veci u desno */
    for(j = 0 , ind = 0 ; j < i - 1 ; j++)
      if(a[j] > a[j + 1])
	{
	  int temp = a[j];
	  a[j] = a[j + 1];
	  a[j + 1] = temp;

	  /* Promenljiva ind registruje da je bilo premestanja. Samo
	     u tom slucaju ima smisla ici na sledecu iteraciju, jer 
	     ako nije bilo premestanja, znaci da su svi elementi vec
	     u dobrom poretku, pa nema potrebe prelaziti na kraci prefiks
	     niza. Moglo je naravno i bez ovoga, algoritam bi radio
	     ispravno, ali bi bio manje efikasan, jer bi cesto nepotrebno
	     vrsio mnoga uporedjivanja, kada je vec jasno da je sortiranje
	     zavrseno. */
	  ind = 1;
	}
}



/* Test program */
int main ()
{

  int a[MAX];
  int n;
  int i;

  /* Unosimo dimenziju niza */
  printf ("Uneti dimenziju niza: ");
  scanf ("%d", &n);

  /* Unosimo elemente niza */
  printf ("Uneti elemente niza:\n");
  for (i = 0; i < n; i++)
    scanf ("%d", &a[i]);

  /* Sortiramo niz */
  selection_sort (a, n);
  /* insertion_sort (a,n); */
  /* bubble_sort(a,n) */

  /* Ispisujemo sortirani niz */
  printf ("Niz nakon sortiranja:\n");
  for (i = 0; i < n; i++)
    printf ("%d ", a[i]);
  putchar ('\n');

  return 0;
}
