.text
.align 2


.global rotate

@ Funkcija:
@ 
@ void rotate(int *a, int n, int *b, int k);
@
@ Rotira niz duzine n u desno za k pozicija (k >= 0).
@ Argumenti funkcije su:
@
@ -- r0 -- int * a -- adresa pocetka ulaznog niza
@ -- r1 -- int n -- duzina niza
@ -- r2 -- int * b -- adresa pocetka izlaznog niza
@ -- r3 -- int k -- broj pozicija za koliko rotiramo
@
rotate:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Cuvamo na steku registre koji ce nam biti potrebni
	stmfd sp!, {r4-r8}

	@ U registar r4 smestamo adresu ulaznog niza, u r5 duzinu niza,
	@ a u r6 adresu izlaznog niza. U r7 smestamo broj k.
	mov r4, r0
	mov r5, r1
	mov r6, r2
	mov r7, r3

	@ Registar r8 ce biti brojac u petlji
	mov r8, #0

next_number:
	@ Dokle god je r8 < r5
	cmp r8, r5
	bge last_number

	@ Izracunavamo indeks u nizu b na koji treba smestiti
	@ element iz niza a sa pozicije r8. Ovaj indeks se
	@ racuna po formuli (r8 + k) % n.
	add r0, r8, r7
	mov r1, r5
	bl __modsi3

	@ Ucitavamo u r1 element iz niza a sa pozicije r8, a zatim
	@ ga kopiramo na poziciju r0 u nizu b.	
	ldr r1, [r4, r8, asl #2]
	str r1, [r6, r0, asl #2]
	
	@ Uvecavamo brojac i prelazimo na sledecu iteraciju.
	add r8, r8, #1
	b next_number
last_number:

done:
	@ Skidamo sa steka registre koje smo koristili
	ldmfd sp!, {r4-r8}


	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}
