.intel_syntax noprefix

.data
init_four: .float 1.0, 2.0, 3.0, 4.0  ## Niz realnih konstanti
	
.text 
.global integrate

############################################################################
## void integrate(float * p, int n, float * pp);
##
## izracunava integral polinom stepena n ciji niz koeficienata je dat na
## adresi p (pocev od slobodnog clana). Koeficienti rezultujuceg polinoma
## se smestaju u niz na koji pokazuje pp (pocev od slobodnog clana).
## -- [ebp+8] -- float * p -- adresa niza koeficienata
## -- [ebp+12] -- int n -- stepen polinoma
## -- [ebp+16] -- float *pp -- adresa niza koeficienata rezultata
##
############################################################################	
integrate:
	## Prolog funkcije
	enter 0,0
	push esi
	push edi
	
        ## Proverava se da li procesor podrzava SSE instrukcije.
        mov     eax, 1
        cpuid
        test    edx, 0x2000000
        jz not_supported

        ## Cuva se sadrzaj SSE registara (i registara koprocesora).
        mov     edx, esp
        and     esp, 0xfffffff0
        sub     esp, 512
        fxsave  [esp]


	## Integral polinoma (a0, a1, a2, ..., a_n)  je polinom
	## (0,a0, a1/2 a2/3, a3/4,..., a_n/(n+1)).
	## Zbog toga je dovoljno najpre upisati 0 u rezultujuci niz
	## koeficieneta, a zatim u svakoj iteraciji deliti
	## koeficient a_i sa (i+1) i dobijene vrednosti upisati u
	## odredisni niz.
	

	## Upisujemo u registar esi adresu niza keficienata.
	mov esi, [ebp+8]

	## Upisujemo u edi adresu odredisnog niza. Zatim na prvu lokaciju
	## u tom nizu smestamo 0 i pomeramo pokazivac edi za jednu poziciju
	## u desno.
	mov edi, [ebp+16]
	xorps xmm0, xmm0
	movss [edi], xmm0
	add edi, 4

	## Upisujemo u registar ecx stepen polinoma n i uvecavamo ga za 1,
	## jer je broj koeficienata koje jos treba izracunati n + 1 (jedan je
	## vec izracunat).
	mov ecx, [ebp+12]
	inc ecx

	## U registar xmm0 upisujemo cetvorku (1,2,3,4),dok u registar xmm7
	## upisujemo broj 4 u sva cetiri podatka. U najnizi deo registra xmm6
	## upisujemo vrednost 1.
	movups xmm0, init_four
	movaps xmm7, xmm0
	shufps xmm7, xmm7, 0b11111111
	movss xmm6, xmm0

	## U petlji obradjujemo po cetiri koeficienta paralelno.
next_four:

	## Kada je broj preostalih koeficienata manji od 4, prelazimo na
	## petlju po jedan.
	cmp ecx, 4
	jl remaining

	## U registar xmm1 ucitavamo sledeca 4 koeficienta polinoma.
	movups xmm1, [esi]
	add esi, 16

	## Delimo odgovarajuce koeficiente vrednostima iz registra xmm0,
	## a zatim svaku od tih vrednosti uvecavamo za 4, za sledecu
	## iteraciju.
	divps xmm1, xmm0
	addps xmm0, xmm7

	## Upisujemo koeficiente u odredisni niz.
	movups [edi], xmm1
	add edi, 16

	## Prelazimo na sledeca 4 koeficienta
	sub ecx,4
	jmp next_four

remaining:
	## Ako nije preostao ni jedan koeficient, zavrsavamo funkciju.
	jecxz finish
	
next_one:
	## Ucitavamo sledeci koeficient
	movss xmm1, [esi]
	add esi, 4

	## Delimo koeficient sa vrednoscu najnizeg podatka iz registra
	## xmm0, nakon cega najnizi podatak iz xmm0 uvecavamo za 1.
	divss xmm1, xmm0
	addss xmm0, xmm6

	## Upisujemo rezultat u odredisni niz.
	movss [edi], xmm1
	add edi, 4

	## Prelazimo na sledeci koeficient
	loop next_one

finish:
        ## Vraca se prethodni sadrzaj u registre koprocesora i SSE
	## registre.
        fxrstor [esp]
        mov     esp, edx

	## Epilog funkcije.
done:	
	pop edi
	pop esi
	leave
	ret

not_supported:
	## Ako SSE instrukcije nisu podrzane, prekidamo program exit(1)
	## pozivom. 
	mov eax, 1
	mov ebx, 1
	int 0x80
	