.intel_syntax noprefix

.data
ten: .int 10
	
.text
.global compact

##########################################################################
##
## Funkcija:
##
## void compact(char * s, char * p);
##
## zamenjuje u stringu svaku sekvencu istih karaktera x duzine n > 1 sa xn
## (npr. sekvencu "aaa" zamenjuje sa "a3"). Argumenti funkcije su:
##
## -- char * s  -- [ebp+8]  -- adresa ulaznog stringa
## -- char * p  -- [ebp+12] -- adresa niza u koji treba upisati rezultat
##
###########################################################################
compact:
        ## Prolog funkcije.
        enter   0, 4
        push    ebx
        push    esi
        push    edi

	## U registar esi smestamo adresu stringa.
	mov esi, [ebp + 8]

	## Adresa na koju vrsimo upis bice sacuvana kao lokalna promenljiva
	## zbog nedostatka registara. Registar edi ce biti koriscen dvojako,
	## kao adresa na koju vrsimo upis u trenutku dok se isti vrsi, a
	## inace kao brojac duzine tekuce sekvence.
	mov edi, [ebp + 12]
	mov [ebp - 4], edi
	mov edi, 1

	
	## Postavljamo smer kretanja kroz string
	cld

	## Ucitavamo prvi string u al registar
	lodsb

	## Ako je prazan string, zavrsavamo funkciju.
	cmp al, 0
	je done


	## Registar ah ce cuvati prethodni karakter, a al tekuci.
	mov ah, al
	
next_char:
	## Ucitavamo sledeci karakter
	lodsb

	## Proveravamo da li je tekuci karakter jednak sa prethodnim.
	cmp al, ah
	je equal

not_equal:	

	## Cuvamo vrednosti tekuceg i prethodnog karaktera respektivno
	## u bl i bh, jer ce nam biti potrebni za kasnije.
	mov bl, al
	mov bh, ah
	
	## U registar ecx privremeno cuvamo broj ponavljanja, dok u registar
	## edi smestamo tekucu adresu u izlaznom stringu i upisujemo karakter
	## poslednje sekvence u string.
	mov ecx, edi
	mov edi, [ebp - 4]
	mov al, bh
	stosb
	
	## Ako je broj ponavljanja manji od 2, tada ne upisujemo broj, vec
	## prelazimo na ispitivanje da li je nastupio kraj stringa.
	cmp ecx, 1
	jle check_terminate
	
	## U registar eax smestamo broj ponavljanja prethodnog karaktera.
	## Registar ecx ce nam sluziti kao brojac cifara dekadnog zapisa
	## broja ponavljanja.
	mov eax, ecx
	xor ecx, ecx
	
next_digit:
	## Delimo edi sa 10 i ostatak (dekadnu cifru) smestamo na stek (tako
	## da ce cifre biti postavljane na stek u obrnutom redosledu, a
	## prilikom skidanja sa steka bice u pravom redosledu). Brojac cifara
	## uvecavamo za 1 (registar ecx).
	xor edx, edx
	div dword ptr ten
	push edx
	inc ecx

	## Ako je nakon deljenja kolicnik jednak nuli, tada nema vise cifara,
	## pa izlazimo iz petlje.
	cmp eax, 0
	je last_digit
	jmp next_digit
last_digit:
	
	## Petlja se vrti ecx puta i u svakoj iteraciji skidamo sa steka
	## sledecu dekadnu cifru i smestamo je u string.
put_next:	
	pop eax
	add al, '0'
	stosb
	loop put_next

check_terminate:
	## Smestamo tekucu adresu ispisa ponovo u lokalnu promenljivu.
	mov [ebp - 4], edi
	## Proveravamo da li je tekuci karakter jednak terminirajucoj nuli
	cmp bl, 0
	jne prepare

terminate:
	## Ako jeste, dodajemo terminirajucu nulu na kraj stringa i zavrsavamo
	## funkciju. 
	mov al, 0
	stosb
	jmp done

prepare:
	## Postavljamo prehodni karakter na tekuci, i inicijalizujemo brojac
	## na 1.
	mov ah, bl
	mov edi, 1
	jmp continue
	
equal:
	## U slucaju da je tekuci karakter jednak prethodnom, tada samo
	## uvecavamo brojac.
	inc edi
	
continue:
	## Prelazimo na sledeci karakter.
	jmp next_char

	
done:	
	## Epilog funkcije
	pop edi
	pop esi
	pop ebx
	leave
	ret
	