.intel_syntax noprefix


.text
.global square_free

###########################################################################
##
## Funkcija ispituje da li je dati prirodan broj x kvadratno slobodan.
## Broj x je kvadratno slobodan ako za svaki prost broj p koji deli x, broj
## p^2 ne deli x. Funkcija vraca 1 ako je broj kvadratno slobodan, u
## suprotnom vraca 0.
##	
## int square_free(int x);
##
## -- int x -- [ebp+8] -- broj za koji se ispituje da li je kvadratno
##                        slobodan.
###########################################################################
	
square_free:
	## Prolog funkcije
	enter 0,0
	push edi
	push ebx

	## Ideja algoritma: Jasno je da je broj kvadratno slobodan ako je
	## visestrukost svih njegovih prostih faktora jednaka 1. Neka je
	## broj x = p1^e1 * p2^e2 * ... * pk^ek gde su p1, p2, ..., pk
	## prosti cinioci broja x, a e1, e2, ..., ek visestrukosti ovih
	## prostih cinilaca u faktorizaciji broja x. Neka je
	## p1 < p2 < ... < pk. Tada je najmanji delilac (razlicit od 1)
	## broja x upravo p1. Zato cemo u petlji traziti prvi delilac broja
	## x pocev od 2. Kada ga pronadjemo, to je upravo p1.
	## Nakon sto podelimo x sa p1, ispitacemo da li je x sada deljivo sa
	## p1, tj. da li je e1 > 1. Ako jeste, tada broj nije kvadratno
	## slobodan. U suprotnom imamo da je e1 = 1, a x je sada jednako
	## p2^e2 * ... * pk^ek, pa je najmanji sledeci delilac broja x sada
	## p2. Kada ga pronadjemo, ponavljamo isti postupak kao za p1. Ovaj
	## proces se nastavlja dokle god ne obradimo sve proste cinioce, tj.
	## dok ne bude x == 1, ili dok ne pronadjemo prost cinilac
	## visestrukosti vece od 1.

	## Registar ebx ce nam sadrzati tekucu vrednost broja x.
	mov ebx, [ebp+8]

	## Registar edi cemo uvecavati u petlji dok ne pronadjemo prvi broj
	## kojim je deljiv broj x. 
	mov edi, 1
		
next_factor:
	## Ako je tekuca vrednost broja x jednaka 1, tada je broj kvadratno
	## slobodan.
	cmp ebx, 1
	je success

	## Ispitujemo za sledeci broj da li je delilac broja x.
	inc edi

	## Delimo x sa tekucom vrednoscu registra edi.
	mov eax, ebx
	xor edx, edx
	div edi

	## Ako je x deljivo sa edi, tada smo pronasli sledeci prost cinilac
	## broja x. 
	cmp edx, 0
	jne continue

	## Azuriramo x, tj. postavljamo x = x / edi
	mov ebx, eax

	## Proveravamo da li je x nakon deljenja sa edi i dalje deljivo sa edi.
	xor edx, edx
	div edi

	## Ako jeste, tada broj nije kvadratno slobodan. 
	cmp edx, 0
	je failed

continue:
	## U suprotnom prelazimo na sledeci prost cinilac.
	jmp next_factor

failed:
	## U slucaju neuspeha vracamo 0.
	xor eax, eax
	jmp done

success:
	## U slucaju uspeha vracamo 1.
	mov eax, 1
	jmp done
	
done:	
	## Epilog funkcije
	pop ebx
	pop edi
	leave
	ret
	
