.intel_syntax noprefix

	
.text

.global expfun

#############################################################################
##
## Funkcija:
## 
## double expfun(double a, double h, int n);
##
## racuna sumu vrednosti funkcije f(x) u tackama a, a+h, a+2h, ..., a+(n-1)h
## gde je funkcija f(x) zadata na sledeci nacin:
##
## f(x) = e^(xsin(x)+cos(x))/(sin^2(x)+2cos(x))
##
## Argumenti funkcije su:
##
## -- double a  --  [ebp+8]  -- pocetna tacka
## -- double h  --  [ebp+16] -- korak
## -- int n     --  [ebp+24] -- broj tacaka
#############################################################################
expfun:
	## Prolog funkcije
	enter 0,0

	fldz		         ## stek: 0 = S
	fld qword ptr [ebp+8]	 ## stek: S,a = x
	fld qword ptr [ebp+16]	 ## stek: S,x,h

	## U ecx smestamo n. Ovaj registar ce biti brojac.
	mov ecx, [ebp+24]
	
next:
	fld st(1)		 ## stek: S,x,h,x
	fsincos                  ## stek: S,x,h,sin(x),cos(x)
	fxch                     ## stek: S,x,h,cos(x),sin(x)
	fmul st(0), st(3)        ## stek: S,x,h,cos(x),x*sin(x)
	faddp			 ## stek: S,x,h,cos(x)+x*sin(x)=L
	
	fldl2e			 ## stek: S,x,h,L,log_2(e)
	fmulp			 ## stek: S,x,h,L*log_2(e)=R
	fld st(0)		 ## stek: S,x,h,R,R
	frndint                  ## stek: S,x,h,R,int(R)
	fsub st(1), st(0)        ## stek: S,x,h,R-int(R)=frac(R),int(R)
	fxch			 ## stek: S,x,h,int(R),frac(R)
	f2xm1			 ## stek: S,x,h,int(R),2^frac(R)-1
	fld1			 ## stek: S,x,h,int(R),2^frac(R)-1,1
	faddp			 ## stek: S,x,h,int(R),2^frac(R)
	fscale			 ## stek: S,x,h,int(R),2^(frac(R)+int(R))
				 ## stek: S,x,h,int(R),2^R
	fxch			 ## stek: S,x,h,2^R,int(R)
	fcomp			 ## stek: S,x,h,2^R=e^L

	fld st(2)		 ## stek: S,x,h,e^L,x
	fsincos			 ## stek: S,x,h,e^L,sin(x),cos(x)
	fadd st(0), st(0)        ## stek: S,x,h,e^L,sin(x),2*cos(x)
	fxch			 ## stek: S,x,h,e^L,2*cos(x),sin(x)
	fmul st(0), st(0)        ## stek: S,x,h,e^L,2*cos(x),sin^2(x)
	faddp                    ## stek: S,x,h,e^L,2*cos(x)+sin^2(x)
	fdivp                    ## stek: S,x,h,e^L/(2*cos(x)+sin^2(x))=f(x)
	faddp st(3), st(0)       ## stek: Sn,x,h
	fadd st(1), st(0)        ## stek: Sn,xn,h

			##	Sn i xn su vrednosti S i x nakon uvecanja
	
				 ## stek: S,x,h
	loop next

	fcompp			## stek: S
	
done:	
	## Epilog funkcije
	leave
	ret
