#ifndef _BITOVI_H
#define _BITOVI_H

/* VAZNA NAPOMENA: S obzirom da je u velikim projektima tesko iskontrolisati
   gde se koje zaglavlje ukljucuje, postoji opasnost da se neka zaglavlja u
   nekom fajlu ukljucuju vise puta (sto posredno, sto neposredno). Ponekad
   to samo usporava prevodjenje, a ponekad dovodi i do gresaka (npr. u C++-u
   je greska ako se ista klasa definise vise puta u istom fajlu, a definicije
   klasa obicno budu u zaglavljima, pa se ukljucuju u fajlove sa kodom). Zbog
   toga je bitno izbeci visestruko ukljucivanje zaglavlja. Ovo se postize 
   uslovnim prevodjenjem: samo ako neka pogodno izabrana jedinstvena konstanta
   (u ovom slucaju _BITOVI_H) nije definisana (direktiva #ifndef) ukljucuje
   se zaglavlje (i pritom se definise _BITOVI_H pomocu #define). Svaki sledeci
   pokusaj ukljucivanja tog zaglavlja u isti fajl bice sprecen, jer ce
   konstanta _BITOVI_H vec biti definisana. Obratiti paznju da se na kraju
   zaglavlja mora nalaziti direktiva #endif.
*/


/* Definicije tipova podataka */

typedef union {
  float f;
  unsigned d;
} FD;

typedef union {
  double lf;
  unsigned d[2];
} LFD;

typedef union {
  double lf;
  unsigned long long d;
} LFLD;


/* Deklaracije funkcija */

/* Funkcija prikazuje bitove binarnog zapisa neoznacenog broja x */
void prikazi_unsigned(unsigned x);

/* Funkcija prikazuje bitove binarnog zapisa realnog (float) broja x 
   koristeci se unijskim tipom (bitovski operatori se mogu primeniti 
   samo nad celobrojnim tipovima) */
void prikazi_float(float x);

/* Funkcija prikazuje bitove binarnog zapisa realnog (double) broja x 
   koristeci unijski tip */
void prikazi_double(double x);

/* Funkcija prikazuje bitove podatka tipa unsigned long long */
void prikazi_ull(unsigned long long x);

/* Funkcija prikazuje bitove double podatka. */
void prikazi_double_2(double x);

/* Funkcija prikazuje bitove karakterskog tipa x */
void prikazi_char(unsigned char x);

/* Funkcija prikazuje binarni zapis proizvoljnog podatka na adresi x velicine
   size bajtova */
void prikazi_podatak(void * x, int n);

#endif // _BITOVI_H
