#include <stdio.h>

/* Program ilustruje upotrebu nizova, prilikom brojanja cifara 
   u tekstu koji se zadaje na ulazu */
int main()
{
  /* Za svaku dekadnu cifru definisemo jedan brojac (tj. imamo niz
     od 10 brojaca): brojaci[0] broji koliko se puta pojavio karakter
     '0', brojaci[1] broji koliko se puta pojavio karakter '1' i tako
     dalje. Svi brojaci se inicijalizuju nulama. Donja sintaksa pokazuje
     kako se mogu inicijalizovati elementi niza. Inicijalizatori se 
     razdvajaju zarezima i moraju biti konstante. Ukoliko se navede 
     manje inicijalizatora, tada se njima inicijalizuju pocetni 
     elementi niza. Ako se navede vise inicijalizatora od duzine niza,
     tada se to smatra greskom. Ukoliko se navede inicijalizacija, tada
     nije neophodno navesti dimenziju niza -- ona se automatski odredjuje
     na osnovu broja inicijalizatora (npr. int a[] = {1, 2, 3}; je isto
     sto i int a[3] = {1, 2, 3};) */
  int brojaci[10] = {0,0,0,0,0,0,0,0,0,0};
  int c, i;

  while((c = getchar()) != EOF)
    {
      /* Ako je karakter c dekadna cifra... */
      if(c >='0' && c <= '9')
	brojaci[c - '0']++;    /* Uvecavamo odgovarajuci brojac za 1 */
      
      /* Izraz c - '0' ce u slucaju da je c dekadna cifra imati upravo 
	 vrednost 0, 1, ..., 9 za karaktere '0', '1', ..., '9' respektivno,
	 a to su upravo indeksi u nizu brojaci (jer niz ima 10 elemenata,
	 pa su indeksi od 0 do 9). Time postizaemo da brojaci[0] broji
	 karaktere '0', itd. */
    }

  /* Prikazujemo elemente niza, tj. vrednosti brojaca: */
  for(i = 0; i < 10; i++)
    printf("Karakter %c se pojavljuje %d puta\n", '0' + i, 
	   brojaci[i]);  


  return 0;
}
