#include <stdio.h>

/* NAPOMENA:

   Niz u programskom jeziku C je kolekcija elemenata istog tipa koji se
   u memoriji nalaze na susednim pozicijama. Za svaki tip T (bili prost
   tip, ili neki vec definisani slozeni tip) moguce je definisati niz
   elemenata tog tipa. Ako definisemo:

   T x[100];

   tada je promenljiva x tipa "niz od 100 elemenata tipa T", gde je T
   proizvoljan tip. Ako su tipovi T1, i T2 razliciti, tada su i tipovi
   "niz elemenata T1" i "niz elemenata T2" takodje razliciti. Takodje,
   niz:

   T y[50];

   je tipa "niz od 50 elemenata tipa T", i razlikuje se od tipa promenljive
   x (tj. nizovi razlicitih duzina su razlicitih tipova, cak i kad su im
   elementi istog tipa).

   Kada se niz definise, njegovim elementima se moze pristupati pomocu 
   indeksa: x[i] predstavlja element sa indeksom i. Indeks moze biti bilo
   koji celobrojni izraz. Indeksi nizova u C-u pocinju od 0, tako da u 
   nizu:
   
   int a[100];

   indeksi se krecu od 0 do 99 (pocetni element ima indeks 0, a poslednji ima
   indeks 99). Elementi niza su redom a[0], a[1], ..., a[99]. 

   Programski jezik C ne proverava da li je vrednosti indeksa zaista u 
   dozvoljenom opsegu -- odgovornost je na programeru. Ukoliko se upotrebi
   indeks van dozvoljenog opsega, nece biti prijavljena greska, ali se
   u fazi izvrsenja mogu ocekivati nepredvidivi rezultati (pogresan rezultat,
   "pucanje" programa, i sl.).

   Ako definisemo niz odredjene duzine (npr. 100) to ne znaci da mi moramo
   da koristimo svih 100 -- to je broj elemenata koje smo kreirali u nizu
   u memoriji, a nasa je stvar koliko njih cemo da koristimo. Obicno se 
   koristi prvih n, gde je n <= 100 (tj. od dimenzije niza). Vrednost n
   obicno korisnik unosi na ulazu. 

   Sa elementima niza mozemo da radimo sve sto i sa bilo kojim podatkom 
   odgovarajuceg tipa. 

   Dimenzija niza mora da se navede i mora biti konstantan izraz (tj. izraz
   cija se vrednost moze utvrditi u fazi prevodjenja).
*/

/* Program racuna prosek celih brojeva unetih na ulazu */
int main()
{
  int a[100];
  int n, i; 
  int S = 0;

  /* Ako zelimo da budemo sigurni da je korisnik uneo broj elemenata koji
     je manji ili jednak od dimenzije niza, mozemo da ponavljamo postupak
     unosenja broja elemenata dok korisnik ne unese dozvoljenu vrednost. */
  do {
    printf("Unesite dimenziju niza (<=100): ");
    scanf("%d", &n);
  } while(n > 100);
  
  /* Unosimo elemente niza. Primetimo da indeks i ide od 0 do n - 1 (to su
     upravo indeksi prvih n elemenata niza) */
  for(i = 0; i < n; i++)
    scanf("%d", &a[i]);

  
  /* Racunamo zbir elemenata u promenljivoj S */
  for(i = 0; i < n; i++)
    S += a[i];

  /* Racunamo prosek */
  printf("%f\n", (double)S / n);

  return 0;
}
