#include <stdio.h>

/* Primer demonstrira koriscenje staticke lokalne promenljive. Njena 
   osnovna osobina je da cuva svoje vrednosti izmedju dva poziva 
   funkcije (ili dva izvrsenja bloka u kome je deklarisana). Tako 
   mozemo u sledecem pozivu racunati na vrednost koju je ostavio
   prethodni poziv. Staticke lokalne promenljive se inicijalizuju
   samo jednom -- kada se pokrene izvrsavanje programa (u donjem
   primeru, promenljiva ind se postavlja na 1 samo jednom, prilikom
   pokretanja programa, a ne svaki put kada se udje u funkciju, sto
   je slucaj sa automatskim promenljivama). */

/* Funkcija prikazuje broj x samo ako je veci od do sada najveceg
   broja za koji je funkcija pozivana (ili ako je prvi put pozvana,
   sto kontrolise promenljiva ind) */
void prikazi(int x)
{
  static int max, ind = 1;

  if(ind || x > max)
    {
      printf("%d ", x);
      max = x;
      ind = 0;
    }
}

/* Program resava zadatak sa kolokvijuma (s tim sto na kolokvijumu
   nije trebalo koristiti funkcije) */
int main()
{
  int x;

  do {
    scanf("%d", &x);
    prikazi(x);
  
  } while(x != 0);

  return 0;
}
