#include <stdio.h>
#include <math.h>

/* NAPOMENA: 

   Promenljive u C-u se razvrstavaju po dva kriterijuma: po TRAJANJU i
   po DOMETU. TRAJANJE promenljive definise kada se promenljiva kreira
   u memoriji i kada se unistava -- postoje AUTOMATSKE i STATICKE promenljive.
   DOMET definise u kom delu programa se promenljiva "vidi", tj. u kom delu 
   programa mozemo da joj pristupamo koristeci njen identifikator. Promenljive
   mogu imati LOKALNI i GLOBALNI domet. 

   Automatske promenljive se kreiraju kada se udje u deo programa (funkciju 
   ili blok) u kome su deklarisane, a unistavaju se kada se izadje iz 
   tog dela programa (i tako svaki put). Staticke promenljive se kreiraju
   kada se pokrene program, a unistavaju se kada se program zavrsi (one dakle
   postoje sve vreme u memoriji, na istoj adresi). Staticke promenljive se
   uvek inicijalizuju nulom, ako drugacije nije navedeno, dok se automatske
   promenljive ne inicijalizuju (osim ako nije eksplicitno navedena inicijalna
   vrednost).

   Lokalne promenljive su one koje su deklarisane unutar neke funkcije ili
   bloka. One su vidljive samo u toj funkciji ili bloku. Globalne promenljive
   su one koje su deklarisane izvan svih funkcija, na globalnom nivou. One
   su vidljive svim funkcijama koje su definisane ispod njih u tom istom 
   c-fajlu.

   Lokalne promenljive su podrazumevano automatske. Ukoliko zelimo da 
   lokalna promenljiva bude staticka, potrebno je ispred nje navesti 
   kljucnu rec static:

   static int x;

   Globalne promenljive su uvek staticke (ne mogu biti automatske!!).

*/

#define EPS 0.000001
 
double x1, x2;  /* Globalne promenljive u koje upisujemo resenja */

int kvadratna_jednacina(double a, double b, double c) 
{
  double D;

  D = b * b - 4 * a * c;

  if(D < 0)
    return 0;
  else if(fabs(D) < EPS)
    {
      x1 = -b / (2 * a);
      return 1;
    }
  else 
    {
      x1 = (-b + sqrt(D)) / (2 * a);
      x2 = (-b - sqrt(D)) / (2 * a);
      return 2;
    }


}


int main()
{

  double a, b, c;
  int r;

  scanf("%lf %lf %lf", &a, &b, &c);

  /* Poziv funkcije vraca broj realnih resenja (i eventualno u globalne
     promenljive upisuje resenja) */
  r = kvadratna_jednacina(a, b, c); 

  /* Diskutujemo po broju resenja i ispisujemo vrednosti 
     globalnih promenljivih, ako realna resenja postoje */
  if(r == 0)
    printf("Nema resenja!\n");
  else if(r == 1)
    {
      printf("Jedno realno resenja: %f\n", x1);
    }
  else
    {
      printf("Dva realna resenja: %f i %f\n", x1, x2);
    }

  return 0;
}
