/* Uslovi koji se ispituju */
`define COND_JMP 0
`define COND_JE  1
`define COND_JNE 2
`define COND_JA  3
`define COND_JB  4
`define COND_JAE 5
`define COND_JBE 6
`define COND_JG  7
`define COND_JL  8
`define COND_JGE 9
`define COND_JLE 10

/* Vrednosti FALSE i TRUE */
`define FALSE 1'b0
`define TRUE 1'b1

/* Flegovi */
`define CF 2'd0
`define ZF 2'd1
`define SF 2'd2
`define OF 2'd3

/* Ovo pomocno kombinatorno kolo zapravo se instancira unutar 
 kontrolne jedinice, gde mu je uloga da na osnovu izabranog
 koda uslova i trenutne vrednosti PSW registra odredjuje da li
 je trazeni uslov ispunjen ili ne. */
module psw_checker(cond_code, psw, out);
   input [3:0] cond_code;
   input [3:0] psw;
   output reg    out;

   always @(cond_code or psw)
     case(cond_code)
       `COND_JMP:
	 out <= `TRUE;
       `COND_JE:
	 out <= psw[`ZF];
       `COND_JNE:
	 out <= ~psw[`ZF];
       `COND_JA:
	 out <= ~(psw[`ZF] | psw[`CF]);
       `COND_JB:
	 out <= psw[`CF];
       `COND_JAE:
	 out <= ~psw[`CF];
       `COND_JBE:
	 out <= psw[`ZF] | psw[`CF];
       `COND_JG:
	 out <= ~(psw[`ZF] | (psw[`OF] ^ psw[`SF]));
       `COND_JL:
	 out <= psw[`OF] ^ psw[`SF];
       `COND_JGE:
	 out <= ~(psw[`OF] ^ psw[`SF]);
       `COND_JLE:
	 out <= psw[`ZF] | (psw[`OF] ^ psw[`SF]);
       default:
	 out <= `FALSE;       
     endcase
endmodule // psw_checker

