/* Kolo predstavlja PC registar koji cuva adresu tekuce instrukcije. 
   Moguce je vrednost ovog registra poslati na bilo koju od magistrala.
   Prilikom ucitavanja sa A magistrale vrednost se upisuje u registar
   kao apsolutna vrednost. Prilikom ucitavanja sa B magistrale vrsi
   se dodavanje vrednosti bus_b[31:8] * 4 na trenutnu vrednost registra 
   (ovo se koristi kod relativnog adresiranja). Takodje, postoji i 
   e_inc signal koji uvecava vrednost registra za 4 (prelazak na 
   sledecu instrukciju) */
module pc(bus_a, bus_b, e_a_in, e_b_in, e_a_out, e_b_out, e_inc);
   inout[31:0] bus_a, bus_b;
   input       e_a_in, e_b_in;
   input       e_a_out, e_b_out;
   input       e_inc;   
   
   reg [31:0]  r;

   assign bus_a = e_a_out ? r : 32'hzzzzzzzz;
   assign bus_b = e_b_out ? r : 32'hzzzzzzzz;

   always @(bus_a or e_a_in)
     if(e_a_in)
       r <= bus_a;

   always @(bus_b or e_b_in)
     if(e_b_in)
       begin 
	  r <= r + (({ {6{bus_b[31]}}, {26{1'b0}} } | (bus_b >> 6)) & 32'hfffffffc);
       end
   
   always @(posedge e_inc)      
     r <= r + 32'd4;
 
   initial
     r <= 0;

   always @(r)
     $display($time, ": pc = %h", r);
   
   
endmodule // pc
