/* Vrednosti 'enable' signala */
`define DISABLE 0
`define ENABLE 1

/* Stanja konacnog automata memorije */
`define IDLE 0
`define REQUEST_RECV 1
`define READY 2
`define DATA_RECV 3
`define FINISHED 4

module memory(clk, data, addr, mem_rd, mem_wr, mem_sent, mem_status);
   input clk, mem_rd, mem_wr, mem_sent;
   output reg mem_status;
   input [31:0] addr;
   inout [31:0] data;

   reg [31:0] 	_regs[0 : 30'hffff];
   reg [2:0] 	state;
   reg [31:0] 	buff;
   

   assign data = buff; 
   
   initial
     state <= `IDLE;

   initial
     buff <= 32'hzzzzzzzz;
   
   initial
     mem_status <= 0;
      
   always @(posedge clk)
     begin
	case(state)
	  `IDLE:
	    begin
	       if(mem_rd || mem_wr)
		 state <= `REQUEST_RECV;	       
	    end
	  `REQUEST_RECV:
	    begin
	       if(mem_rd || mem_wr)
		 begin
		    // Za simulaciju kasnjenja memorije
		    //repeat(10) @(posedge clk) ;
		    
		    mem_status <= `ENABLE;		    
		    state <= `READY;		    
		 end
	       else
		 state <= `IDLE;		    
	    end 
	  `READY:
	    begin
	    if(mem_sent)
	      state <= `DATA_RECV;	       
	    end
	  `DATA_RECV:	    
	    begin
	       // Za simulaciju kasnjenja memorije
	       //repeat(100) @(posedge clk) ;

	       if(mem_rd)
		 begin
		    buff <= _regs[addr >> 2];
		    $display($time, ": read: mem[%h]", addr);		    
		 end
	       else if(mem_wr)
		 begin
		    _regs[addr >> 2] <= data;
		    $display($time, ": write: mem[%h]=%d", addr, data);		    
		 end
	       mem_status <= `DISABLE;	       
	       state <= `FINISHED;	       	       		 
	    end
	  `FINISHED:
	    begin
	       if(!mem_rd && !mem_wr)
		 begin
		    buff <= 32'hzzzzzzzz;		    
		    state <= `IDLE;
		 end
	    end
	endcase	
     end

   always @(state)
     case(state)
       `IDLE:
	 $display($time, ": mem_state: IDLE");
       `REQUEST_RECV:
	 $display($time, ": mem_state: REQUEST_RECV");
       `READY:
	 $display($time, ": mem_state: READY");
       `DATA_RECV:
	 $display($time, ": mem_state: DATA_RECV");
       `FINISHED:
	 $display($time, ": mem_state: FINISHED");
     endcase
   
   
endmodule // memory
