`include "alu.v"
`include "mdr.v"
`include "mar.v"
`include "regs.v"
`include "ir.v"
`include "pc.v"
`include "ac.v"
`include "psw.v"
`include "cu.v"

/* Model procesora opste namene. Na ulazu ima signal casovnika clk koji kontrolise
   ritam njegovog rada. Magistrala podataka data je dvosmerna, dok je adresna 
   magistrala addr izlazna magistrala preko koje se salje adresa memoriji. Signali
   mem_* sluze za komunikaciju sa memorijom, dok je halt_signal namenjen iskljucivanju
   racunara */
module cpu(clk, data, addr, mem_rd, mem_wr, mem_sent, mem_status, halt_computer);
   input clk;
   inout [31:0] data;
   output [31:0] addr;
   output 	 mem_rd;
   output 	 mem_wr;
   output 	 mem_sent;
   output 	 halt_computer;	 
   input 	 mem_status;

   wire [31:0] 	 bus_a;
   wire [31:0] 	 bus_b;
   wire [3:0] 	 reg_a_sel;
   wire [3:0] 	 reg_b_sel;

   wire 	 e_reg_a_in, e_reg_b_in, e_reg_a_out, e_reg_b_out, 
		 e_alu, 
		 e_ac_alu_in, e_ac_a_out, e_ac_b_out,
		 e_psw_in,
		 e_pc_a_in, e_pc_b_in, e_pc_a_out, e_pc_b_out, e_pc_inc,
		 e_ir_a_in, e_ir_b_in,
		 e_mar_a_in, e_mar_b_in, e_addr_out, e_calc_addr,
		 e_mdr_a_in, e_mdr_b_in, e_data_in, e_mdr_a_out, e_mdr_b_out, e_data_out, e_calc_const;
 
   
   wire [3:0] 	 psw_in, psw_out;
   wire [3:0] 	 alu_op;
   wire [31:0] 	 alu_out;
   wire [7:0] 	 ir_op_code;
   wire [3:0] 	 ir_dst_reg;
   wire [3:0] 	 ir_src_reg;

   /* Instanciramo komponente procesora */
   regs _regs(bus_a, bus_b, reg_a_sel, reg_b_sel, e_reg_a_in, e_reg_b_in, e_reg_a_out, e_reg_b_out);
   alu _alu(e_alu, bus_a, bus_b, psw_out[`CF], alu_op, alu_out, psw_in[`OF], psw_in[`SF], psw_in[`ZF], psw_in[`CF]);
   psw _psw(psw_in, psw_out, e_psw_in);
   ac _ac(bus_a, bus_b, alu_out, e_ac_alu_in, e_ac_a_out, e_ac_b_out);
   pc _pc(bus_a, bus_b, e_pc_a_in, e_pc_b_in, e_pc_a_out, e_pc_b_out, e_pc_inc);
   ir _ir(bus_a, bus_b, ir_op_code, ir_dst_reg, ir_src_reg, e_ir_a_in, e_ir_b_in);   
   mar _mar(bus_a, bus_b, addr, e_mar_a_in, e_mar_b_in, e_addr_out, e_calc_addr);
   mdr _mdr(bus_a, bus_b, data, e_mdr_a_in, e_mdr_b_in, e_data_in, e_mdr_a_out, e_mdr_b_out, e_data_out, e_calc_const);

   /* Kontrolna jedinica */
   cu _cu(clk, psw_out, ir_op_code, ir_dst_reg, ir_src_reg,
	  e_reg_a_in, e_reg_b_in, e_reg_a_out, e_reg_b_out, 
	  e_alu, 
	  e_ac_alu_in, e_ac_a_out, e_ac_b_out,
	  e_psw_in,
	  e_pc_a_in, e_pc_b_in, e_pc_a_out, e_pc_b_out, e_pc_inc,
	  e_ir_a_in, e_ir_b_in,
	  e_mar_a_in, e_mar_b_in, e_addr_out, e_calc_addr,
	  e_mdr_a_in, e_mdr_b_in, e_data_in, e_mdr_a_out, e_mdr_b_out, e_data_out, e_calc_const,	  
	  alu_op, reg_a_sel, reg_b_sel, mem_rd, mem_wr, mem_sent, mem_status, halt_computer);   	     
   
endmodule // cpu
