`timescale 1ns/1ns

`include "cpu.v"
`include "memory.v"

/* Ovaj modul predstavlja jednostavni model racunara sa procesorom i memorijom.
 Modul se koristi za simulaciju. */
module computer;

   reg clk; // Casovnik
   wire [31:0] data, addr; // Magistrale
   wire        mem_rd, mem_wr, mem_status; // Kontrolni signali  
   wire        halt_computer; // Signal za iskljucivanje racunara

   /* Memorija i procesor */
   memory _memory(clk, data, addr, mem_rd, mem_wr, mem_sent, mem_status);   
   cpu _cpu(clk, data, addr, mem_rd, mem_wr, mem_sent, mem_status, halt_computer);

   /* Proces koji inicijalizuje memoriju na osnovu sadrzaja datog fajla 
    Casovnik se postavlja na 0. */
   initial
     begin
	$readmemh("sabiranje.txt", _memory._regs);
	clk = 0;
     end

   /* Proces koji predstavlja casovnik koji menja svoje stanje svake nanosekunde 
      (sto odgovara frekvenciji od 500MHz) */
   always #1 clk = ~clk;      

   /* Proces koji se aktivira kada se ukljuci halt_signal i prekida simulaciju */
   always @(posedge halt_computer)
     begin
	$finish;
     end

   
   
     
endmodule // computer

