.text
.align 2


.global rotate

@ Funkcija:
@ 
@ void rotate(int *a, int n, int k);
@
@ Rotira niz duzine n u desno za k pozicija (k >= 0).
@ Argumenti funkcije su:
@
@ -- r0 -- int * a -- adresa pocetka ulaznog niza
@ -- r1 -- int n -- duzina niza
@ -- r3 -- int k -- broj pozicija za koliko rotiramo
@
rotate:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Cuvamo na steku registre koji ce nam biti potrebni
	stmfd sp!, {r4-r7}

	@ U registar r4 smestamo a, u registar r5 smestamo n, dok u 
	@ registar r6  smestamo k. Registar r7 cemo koristiti za 
	@ brojac u petlji.	
	mov r4, r0
	mov r5, r1
	mov r6, r2
	mov r7, #0
	
next_rotation:
	@ Dok je i < k
	cmp r7, r6
	beq last_rotation

	@ Rotiramo niz za jednu poziciju u desno
	mov r0, r4
	mov r1, r5
	bl rotate_one
	
	@ Uvecavamo i
	add r7, r7, #1
	b next_rotation
last_rotation:


done:
	@ Skidamo sa steka registre koje smo koristili
	ldmfd sp!, {r4-r7}


	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}


@ Pomocna funkcija:
@ 
@  void rotate_one(int *a, int n);
@ 
@ koji rotira niz a duzine n za jednu poziciju u desno.
@ Argumenti funkcije:
@
@ -- int * a -- r0
@ -- int n   -- r1
@
rotate_one:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Cuvamo na steku registre koji ce nam biti potrebni
	stmfd sp!, {r4}
		
	@ Cuvamo poslednji element niza u registru r4. U r1 racunamo 
	@ n - 1, sto je indeks poslednjeg elementa u nizu.
	sub r1, r1, #1
	ldr r4, [r0, r1, asl #2]	

	@ Registar r2 ce biti brojac u petlji. Inicijalizujemo ga na 
	@ n - 2.
	sub r2, r1, #1
next_element:
	@ Dok je k >= 0...
	cmp r2, #0
	blt last_element

	@ x = a[k];
	ldr r3, [r0, r2, asl #2]
	@ k = k + 1;
	add r2, r2, #1
	@ a[k] = x;     
	str r3, [r0, r2, asl #2]
	
	@ k = k - 2; (umanjujemo k za 1 u odnosu na polaznu vrednost)
	sub r2, r2, #2	

	b next_element
last_element:

	@ Smestamo posledni element na poziciju a[0]
	str r4, [r0]

	@ Skidamo sa steka registre koje smo koristili
	ldmfd sp!, {r4}
	
	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}
